/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.utils;

import com.mojang.blaze3d.textures.GpuTexture;
import io.dampen59.mineboxadditions.MineboxAdditions;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_10868;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class ImageUtils {
    public static class_2960 createTextureFromBufferedImage(BufferedImage image, String identifierName) {
        if (image == null) {
            MineboxAdditions.LOGGER.error("Cannot create texture from null image: {}", (Object)identifierName);
            return null;
        }
        try {
            class_1011 nativeImage = new class_1011(class_1011.class_1012.field_4997, image.getWidth(), image.getHeight(), false);
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    int argb = image.getRGB(x, y);
                    nativeImage.method_61941(x, y, argb);
                }
            }
            class_2960 id = class_2960.method_60655((String)"mineboxadditions", (String)identifierName);
            Runnable register = () -> {
                try {
                    class_1043 tex = new class_1043(() -> ((class_2960)id).toString(), nativeImage);
                    class_310.method_1551().method_1531().method_4616(id, (class_1044)tex);
                    MineboxAdditions.LOGGER.info("Texture registered: {}", (Object)id);
                }
                catch (Exception e) {
                    MineboxAdditions.LOGGER.error("Error registering texture {}: ", (Object)id, (Object)e);
                }
            };
            if (class_310.method_1551().method_18854()) {
                register.run();
            } else {
                class_310.method_1551().execute(register);
            }
            return id;
        }
        catch (Exception e) {
            MineboxAdditions.LOGGER.error("Error creating texture {}: ", (Object)identifierName, (Object)e);
            return null;
        }
    }

    public static class_2960 createTextureFromBase64(@NotNull String base64, String identifierName) {
        try {
            BufferedImage image = ImageUtils.decodeBase64ToImage(base64);
            return ImageUtils.createTextureFromBufferedImage(image, identifierName);
        }
        catch (Exception e) {
            MineboxAdditions.LOGGER.error(e.toString());
            MineboxAdditions.LOGGER.error(Arrays.toString(e.getStackTrace()));
            return null;
        }
    }

    public static BufferedImage decodeBase64ToImage(String base64Image) {
        if (base64Image == null || base64Image.isEmpty()) {
            MineboxAdditions.LOGGER.error("Base64 image string is null or empty");
            return null;
        }
        try {
            byte[] imageBytes;
            if (base64Image.startsWith("data:image")) {
                MineboxAdditions.LOGGER.info("Detected data URL format, extracting base64 content");
                base64Image = base64Image.split(",")[1];
            }
            try {
                imageBytes = Base64.getDecoder().decode(base64Image);
            }
            catch (IllegalArgumentException e) {
                MineboxAdditions.LOGGER.error("Failed to decode base64: {}", (Object)e.getMessage());
                return null;
            }
            if (imageBytes.length == 0) {
                MineboxAdditions.LOGGER.error("Decoded base64 resulted in empty byte array");
                return null;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);
            BufferedImage image = ImageIO.read(bis);
            if (image == null) {
                MineboxAdditions.LOGGER.error("ImageIO could not read the decoded data as an image");
                return null;
            }
            MineboxAdditions.LOGGER.info("Successfully created image: {}x{}", (Object)image.getWidth(), (Object)image.getHeight());
            return image;
        }
        catch (Exception e) {
            MineboxAdditions.LOGGER.error("Error decoding base64 to image: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return null;
        }
    }

    public static boolean textureExists(class_1060 textureManager, class_2960 id) {
        try {
            class_1044 tex = textureManager.method_4619(id);
            if (tex == null) {
                return false;
            }
            GpuTexture gpu = tex.method_68004();
            if (gpu == null || gpu.isClosed()) {
                return false;
            }
            if (gpu instanceof class_10868) {
                class_10868 gl = (class_10868)gpu;
                int glId = gl.method_68427();
                return glId != 0;
            }
            return true;
        }
        catch (Exception e) {
            MineboxAdditions.LOGGER.warn("Error checking if texture exists: {}", (Object)id, (Object)e);
            return false;
        }
    }
}

