/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.utils;

import io.dampen59.mineboxadditions.features.item.MineboxItem;
import io.dampen59.mineboxadditions.utils.models.Location;
import io.dampen59.mineboxadditions.utils.models.Skill;
import io.dampen59.mineboxadditions.utils.models.SkillData;
import java.time.LocalTime;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_642;
import net.minecraft.class_7417;
import net.minecraft.class_8113;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class Utils {
    private static boolean isOnMinebox = false;
    private static LocalTime time = LocalTime.parse("00:00");
    private static Location previousLocation = Location.UNKNOWN;
    private static Location location = Location.UNKNOWN;
    private static final Map<Skill, SkillData> skills = new EnumMap<Skill, SkillData>(Skill.class);

    public static boolean isOnMinebox() {
        return isOnMinebox;
    }

    public static boolean isInSpawn() {
        return location == Location.SPAWN;
    }

    public static boolean isInHome() {
        return location == Location.HOME;
    }

    public static boolean isInKokoko() {
        return location == Location.KOKOKO;
    }

    public static boolean isInQuadraPlains() {
        return location == Location.QUADRA_PLAINS;
    }

    public static boolean isInBambooPeak() {
        return location == Location.BAMBOO_PEAK;
    }

    public static boolean isInFrostbiteFortress() {
        return location == Location.FROSTBITE_FORTRESS;
    }

    public static boolean isInSandwhisperDunes() {
        return location == Location.SANDWHISPER_DUNES;
    }

    public static Location getPreviousLocation() {
        return previousLocation;
    }

    public static LocalTime getTime() {
        return time;
    }

    public static Location getLocation() {
        return location;
    }

    public static SkillData getSkill(Skill skill) {
        return skills.computeIfAbsent(skill, SkillData::new);
    }

    public static void init() {
        ClientPlayConnectionEvents.JOIN.register(Utils::onJoin);
        ClientPlayConnectionEvents.DISCONNECT.register(Utils::onDisconnect);
    }

    private static void onJoin(class_634 handler, PacketSender sender, class_310 client) {
        String address;
        class_642 server = handler.method_45734();
        isOnMinebox = server != null ? (address = server.field_3761.toLowerCase()).contains("minebox.co") || address.contains("minebox.fr") : false;
    }

    private static void onDisconnect(class_634 handler, class_310 client) {
        isOnMinebox = false;
        previousLocation = Location.UNKNOWN;
        location = Location.UNKNOWN;
    }

    public static void updateTime(String timeStr) {
        time = LocalTime.parse(timeStr);
    }

    public static void updateLocation(@Nullable class_2561 footer) {
        if (!isOnMinebox) {
            return;
        }
        if (footer == null || footer.method_10855().isEmpty()) {
            return;
        }
        String serverId = ((class_2561)footer.method_10855().getLast()).getString().replaceAll("\\r?\\n", "");
        previousLocation = location;
        location = Location.from(serverId);
    }

    public static void showToastNotification(String prmTitle, String prmDescription) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        client.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43470((String)prmTitle), (class_2561)class_2561.method_43470((String)prmDescription)));
    }

    public static class_2561 getPlayerServerName(String playerName) {
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1724 != null) {
            Collection entries = client.field_1724.field_3944.method_2880();
            for (class_640 entry : entries) {
                if (!entry.method_2966().getName().equals(playerName)) continue;
                if (entry.method_2971() == null) break;
                return entry.method_2971();
            }
        }
        return class_2561.method_30163((String)playerName);
    }

    public static boolean itemHaveStats(class_1799 itemStack) {
        class_9290 loresList = (class_9290)itemStack.method_58694(class_9334.field_49632);
        if (loresList == null) {
            return false;
        }
        for (class_2561 lore : loresList.comp_2400()) {
            for (class_2561 sibling : lore.method_10855()) {
                List nestedSiblings = sibling.method_10855();
                for (class_2561 nestedSibling : nestedSiblings) {
                    class_2588 translatableContent;
                    String translationKey;
                    class_7417 class_74172 = nestedSibling.method_10851();
                    if (!(class_74172 instanceof class_2588) || !(translationKey = (translatableContent = (class_2588)class_74172).method_11022()).contains("mbx.stats.")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isMineboxItem(class_1799 itemStack) {
        class_9279 itemData = (class_9279)itemStack.method_58694(class_9334.field_49628);
        if (itemData == null) {
            return false;
        }
        class_2487 nbtData = itemData.method_57461();
        return nbtData != null && nbtData.method_10545("mbitems:id");
    }

    public static String getMineboxItemId(class_1799 itemStack) {
        if (!Utils.isMineboxItem(itemStack)) {
            return null;
        }
        class_9279 itemData = (class_9279)itemStack.method_58694(class_9334.field_49628);
        if (itemData == null) {
            return null;
        }
        class_2487 nbtData = itemData.method_57461();
        if (nbtData == null || !nbtData.method_10545("mbitems:id")) {
            return null;
        }
        return nbtData.method_10558("mbitems:id").orElse(null);
    }

    public static String processIdMismatch(String prmId) {
        switch (prmId) {
            case "transformed_material-bamboo": {
                return "transformed_bamboo";
            }
            case "bag_material-bamboo": {
                return "bag_bamboo";
            }
            case "crate_bamboo": {
                return "crate_material-bamboo";
            }
            case "barrel_bamboo": {
                return "barrel_material-bamboo";
            }
            case "enchanted_bamboo": {
                return "enchanted_material-bamboo";
            }
            case "transformed_material-carrot": {
                return "transformed_carrot";
            }
            case "bag_material-carrot": {
                return "bag_carrot";
            }
            case "crate_carrot": {
                return "crate_material-carrot";
            }
            case "barrel_carrot": {
                return "barrel_material-carrot";
            }
            case "enchanted_carrot": {
                return "enchanted_material-carrot";
            }
            case "transformed_material-beetroot": {
                return "transformed_beetroot";
            }
            case "bag_material-beetroot": {
                return "bag_beetroot";
            }
            case "crate_beetroot": {
                return "crate_material-beetroot";
            }
            case "barrel_beetroot": {
                return "barrel_material-beetroot";
            }
            case "enchanted_beetroot": {
                return "enchanted_material-beetroot";
            }
            case "transformed_material-cactus": {
                return "transformed_cactus";
            }
            case "bag_material-cactus": {
                return "bag_cactus";
            }
            case "crate_cactus": {
                return "crate_material-cactus";
            }
            case "barrel_cactus": {
                return "barrel_material-cactus";
            }
            case "enchanted_cactus": {
                return "enchanted_material-cactus";
            }
            case "transformed_material-cocoa_beans": {
                return "transformed_cocoa_beans";
            }
            case "bag_material-cocoa_beans": {
                return "bag_cocoa_beans";
            }
            case "crate_cocoa_beans": {
                return "crate_material-cocoa_beans";
            }
            case "barrel_cocoa_beans": {
                return "barrel_material-cocoa_beans";
            }
            case "enchanted_cocoa_beans": {
                return "enchanted_material-cocoa_beans";
            }
            case "transformed_material-kelp": {
                return "transformed_kelp";
            }
            case "bag_material-kelp": {
                return "bag_kelp";
            }
            case "crate_kelp": {
                return "crate_material-kelp";
            }
            case "barrel_kelp": {
                return "barrel_material-kelp";
            }
            case "enchanted_kelp": {
                return "enchanted_material-kelp";
            }
            case "transformed_material-melon_slice": {
                return "transformed_melon_slice";
            }
            case "bag_material-melon_slice": {
                return "bag_melon_slice";
            }
            case "crate_melon_slice": {
                return "crate_material-melon_slice";
            }
            case "barrel_melon_slice": {
                return "barrel_material-melon_slice";
            }
            case "enchanted_melon_slice": {
                return "enchanted_material-melon_slice";
            }
            case "transformed_material-nether_wart": {
                return "transformed_nether_wart";
            }
            case "bag_material-nether_wart": {
                return "bag_nether_wart";
            }
            case "crate_nether_wart": {
                return "crate_material-nether_wart";
            }
            case "barrel_nether_wart": {
                return "barrel_material-nether_wart";
            }
            case "enchanted_nether_wart": {
                return "enchanted_material-nether_wart";
            }
            case "transformed_material-potato": {
                return "transformed_potato";
            }
            case "bag_material-potato": {
                return "bag_potato";
            }
            case "crate_potato": {
                return "crate_material-potato";
            }
            case "barrel_potato": {
                return "barrel_material-potato";
            }
            case "enchanted_potato": {
                return "enchanted_material-potato";
            }
            case "transformed_material-pumpkin": {
                return "transformed_pumpkin";
            }
            case "bag_material-pumpkin": {
                return "bag_pumpkin";
            }
            case "crate_pumpkin": {
                return "crate_material-pumpkin";
            }
            case "barrel_pumpkin": {
                return "barrel_material-pumpkin";
            }
            case "enchanted_pumpkin": {
                return "enchanted_material-pumpkin";
            }
            case "transformed_material-sugar_cane": {
                return "transformed_sugar_cane";
            }
            case "bag_material-sugar_cane": {
                return "bag_sugar_cane";
            }
            case "crate_sugar_cane": {
                return "crate_material-sugar_cane";
            }
            case "barrel_sugar_cane": {
                return "barrel_material-sugar_cane";
            }
            case "enchanted_sugar_cane": {
                return "enchanted_material-sugar_cane";
            }
            case "transformed_material-sweet_berries": {
                return "transformed_sweet_berries";
            }
            case "bag_material-sweet_berries": {
                return "bag_sweet_berries";
            }
            case "crate_sweet_berries": {
                return "crate_material-sweet_berries";
            }
            case "barrel_sweet_berries": {
                return "barrel_material-sweet_berries";
            }
            case "enchanted_sweet_berries": {
                return "enchanted_material-sweet_berries";
            }
            case "transformed_material-wheat": {
                return "transformed_wheat";
            }
            case "bag_material-wheat": {
                return "bag_wheat";
            }
            case "crate_wheat": {
                return "crate_material-wheat";
            }
            case "barrel_wheat": {
                return "barrel_material-wheat";
            }
            case "enchanted_wheat": {
                return "enchanted_material-wheat";
            }
        }
        return prmId;
    }

    public static boolean isItemLooted(class_1799 itemStack) {
        if (!Utils.isMineboxItem(itemStack)) {
            return false;
        }
        class_9279 itemData = (class_9279)itemStack.method_58694(class_9334.field_49628);
        if (itemData == null) {
            return false;
        }
        class_2487 nbtData = itemData.method_57461();
        if (nbtData == null || !nbtData.method_10545("mbitems:looted")) {
            return false;
        }
        return nbtData.method_10550("mbitems:looted").map(value -> value == 1).orElse(false);
    }

    public static boolean isInventoryBaseItem(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_65130() == null) {
            return false;
        }
        class_2561 customName = itemStack.method_65130();
        class_7417 class_74172 = customName.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            String key = translatable.method_11022();
            return "mbx.your_stats.title".equals(key) || "mbx.main_menu.title".equals(key);
        }
        return false;
    }

    public static int getItemSize(class_1799 itemStack) {
        if (itemStack == null) {
            return 0;
        }
        if (!Utils.isMineboxItem(itemStack)) {
            return 0;
        }
        class_9290 loresList = (class_9290)itemStack.method_58694(class_9334.field_49632);
        if (loresList == null) {
            return 0;
        }
        for (class_2561 lore : loresList.comp_2400()) {
            Object[] args;
            class_2588 tl;
            class_7417 content = lore.method_10851();
            if (content instanceof class_2588 && "mbx.size".equals((tl = (class_2588)content).method_11022()) && (args = tl.method_11023()).length > 0) {
                return Utils.parseIntArg(args[0]);
            }
            for (class_2561 sibling : lore.method_10855()) {
                Object[] args2;
                class_2588 tl2;
                class_7417 sibContent = sibling.method_10851();
                if (!(sibContent instanceof class_2588) || !"mbx.size".equals((tl2 = (class_2588)sibContent).method_11022()) || (args2 = tl2.method_11023()).length <= 0) continue;
                return Utils.parseIntArg(args2[0]);
            }
        }
        return 0;
    }

    public static String getMineboxItemUid(class_1799 itemStack) {
        if (!Utils.isMineboxItem(itemStack)) {
            return null;
        }
        class_9279 itemData = (class_9279)itemStack.method_58694(class_9334.field_49628);
        if (itemData == null) {
            return null;
        }
        class_2487 nbtData = itemData.method_57461();
        if (nbtData == null) {
            return null;
        }
        class_2487 persistentData = nbtData.method_10562("mbitems:persistent").orElse(null);
        if (persistentData == null || !persistentData.method_10545("mbitems:uid")) {
            return null;
        }
        return persistentData.method_10558("mbitems:uid").orElse(null);
    }

    public static MineboxItem findItemByName(List<MineboxItem> items, String itemName) {
        for (MineboxItem item : items) {
            if (!itemName.equals(item.getId())) continue;
            return item;
        }
        return null;
    }

    public static void displayChatErrorMessage(String prmMessage) {
        class_5250 message = class_2561.method_43470((String)("\u274c " + prmMessage)).method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(false)));
        class_310.method_1551().field_1724.method_7353((class_2561)message, false);
    }

    public static void displayChatSuccessMessage(String prmMessage) {
        class_5250 message = class_2561.method_43470((String)("\u2714 " + prmMessage)).method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(false)));
        class_310.method_1551().field_1724.method_7353((class_2561)message, false);
    }

    public static void displayChatInfoMessage(String prmMessage) {
        class_5250 message = class_2561.method_43470((String)("\ud83d\udec8 " + prmMessage)).method_10862(class_2583.field_24360.method_10977(class_124.field_1078).method_10982(Boolean.valueOf(false)));
        class_310.method_1551().field_1724.method_7353((class_2561)message, false);
    }

    public boolean isHarvestableTextDisplay(class_8113.class_8123 entity) {
        class_2561 text = entity.method_48915();
        class_7417 class_74172 = text.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            String key = translatable.method_11022();
            return key.contains("mbx.harvestable");
        }
        return false;
    }

    public static String formatTime(long totalSeconds) {
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public static String getModVersion() {
        ModMetadata modMetadata = FabricLoader.getInstance().getModContainer("mineboxadditions").isPresent() ? ((ModContainer)FabricLoader.getInstance().getModContainer("mineboxadditions").get()).getMetadata() : null;
        return modMetadata != null ? modMetadata.getVersion().getFriendlyString() : "unknown";
    }

    public static boolean isInteger(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static int parseIntArg(Object arg) {
        if (arg == null) {
            return 0;
        }
        if (arg instanceof class_2561) {
            class_2561 t = (class_2561)arg;
            String s = t.getString().trim();
            return Utils.tryParseInt(s);
        }
        if (arg instanceof Number) {
            Number n = (Number)arg;
            return n.intValue();
        }
        return Utils.tryParseInt(arg.toString().trim());
    }

    private static int tryParseInt(String s) {
        try {
            int slash;
            int space = s.indexOf(32);
            if (space > 0) {
                s = s.substring(0, space);
            }
            if ((slash = s.indexOf(47)) > 0) {
                s = s.substring(0, slash);
            }
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

