/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.dampen59.mineboxadditions.ModConfig;
import io.dampen59.mineboxadditions.audio.AudioManager;
import io.dampen59.mineboxadditions.events.ContainerOpenEvent;
import io.dampen59.mineboxadditions.events.ServerEvents;
import io.dampen59.mineboxadditions.events.ShinyEvent;
import io.dampen59.mineboxadditions.events.SkyEvent;
import io.dampen59.mineboxadditions.events.TooltipEvent;
import io.dampen59.mineboxadditions.events.WorldRendererEvent;
import io.dampen59.mineboxadditions.events.inventory.InventoryEvent;
import io.dampen59.mineboxadditions.events.shop.ShopEventManager;
import io.dampen59.mineboxadditions.gui.AudioDeviceScreen;
import io.dampen59.mineboxadditions.gui.HarvestablesScreen;
import io.dampen59.mineboxadditions.gui.HudEditorScreen;
import io.dampen59.mineboxadditions.gui.MineboxAtlasScreen;
import io.dampen59.mineboxadditions.hud.HudRenderer;
import io.dampen59.mineboxadditions.network.SocketManager;
import io.dampen59.mineboxadditions.state.AudioDeviceState;
import io.dampen59.mineboxadditions.state.State;
import io.dampen59.mineboxadditions.utils.AudioUtils;
import io.dampen59.mineboxadditions.utils.Utils;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class MineboxAdditionsClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mineboxadditions");
    public static MineboxAdditionsClient INSTANCE;
    private static class_304 openModSettings;
    private static class_304 openAudioSettings;
    public static class_304 openEditMode;
    public static class_304 openHarvestables;
    public static class_304 openAtlas;
    public ModConfig config = null;
    public State modState = null;

    public void onInitializeClient() {
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);
        this.config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        this.modState = new State();
        new SocketManager(this.modState);
        new ServerEvents(this.modState);
        new ShopEventManager(this.modState);
        new InventoryEvent(this.modState);
        new ContainerOpenEvent(this.modState);
        new TooltipEvent(this.modState);
        new SkyEvent(this.modState);
        new ShinyEvent(this.modState);
        new WorldRendererEvent();
        new AudioManager(this.modState);
        new HudRenderer(this.modState);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> this.registerCommands((CommandDispatcher<FabricClientCommandSource>)dispatcher));
        this.registerKeybinds();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (openAudioSettings.method_1436()) {
                class_310.method_1551().method_1507((class_437)new AudioDeviceScreen());
            }
            if (openEditMode.method_1436()) {
                client.method_1507((class_437)new HudEditorScreen());
            }
            if (openAtlas.method_1436()) {
                if (MineboxAdditionsClient.INSTANCE.modState.getMbxItems() == null) {
                    Utils.displayChatErrorMessage(class_2561.method_43471((String)"mineboxadditions.strings.errors.missing_atlas_data").getString());
                    return;
                }
                client.method_1507((class_437)new MineboxAtlasScreen());
            }
            if (openHarvestables.method_1436()) {
                client.method_1507((class_437)new HarvestablesScreen());
            }
            if (openModSettings.method_1436() && client.field_1755 == null) {
                class_437 configScreen = (class_437)AutoConfig.getConfigScreen(ModConfig.class, (class_437)client.field_1755).get();
                client.method_1507(configScreen);
            }
        });
        AudioDeviceState.micGainDb = this.config.micGainDb;
        AudioDeviceState.selectedInput = AudioUtils.getMixerByName(this.config.selectedMicName, true);
        AudioDeviceState.selectedOutput = AudioUtils.getMixerByName(this.config.selectedSpeakerName, false);
        INSTANCE = this;
    }

    private void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mba").then(ClientCommandManager.literal((String)"vc").then(ClientCommandManager.literal((String)"create").executes(context -> {
            this.modState.getSocket().emit("C2SCreateAudioRoom", new Object[0]);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mba").then(ClientCommandManager.literal((String)"vc").then(ClientCommandManager.literal((String)"join").then(ClientCommandManager.argument((String)"code", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String code = StringArgumentType.getString((CommandContext)context, (String)"code");
            this.modState.getSocket().emit("C2SJoinAudioRoom", new Object[]{code});
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mba").then(ClientCommandManager.literal((String)"vc").then(ClientCommandManager.literal((String)"proximity").executes(context -> {
            this.modState.getSocket().emit("C2SToggleProximityAudio", new Object[0]);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mba").then(ClientCommandManager.literal((String)"vc").then(ClientCommandManager.literal((String)"leave").executes(context -> {
            this.modState.getSocket().emit("C2SLeaveAudioRoom", new Object[0]);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mba").then(ClientCommandManager.literal((String)"debug").executes(context -> {
            Utils.displayChatInfoMessage("=== MineboxAdditions Debug Informations ===");
            Utils.displayChatInfoMessage("Mod Version: " + Utils.getModVersion());
            Utils.displayChatInfoMessage("Socket state: " + (String)(this.modState.getSocket().connected() ? "connected (ID : " + this.modState.getSocket().id() + ")" : "disconnected"));
            Utils.displayChatInfoMessage("Rain Data: " + this.modState.getWeatherState().getRainTimestamps().stream().map(String::valueOf).collect(Collectors.joining(", ")));
            Utils.displayChatInfoMessage("Storm Data: " + this.modState.getWeatherState().getStormTimestamps().stream().map(String::valueOf).collect(Collectors.joining(", ")));
            Utils.displayChatInfoMessage("Shiny Length: " + this.modState.getMbxShiniesUuids().size());
            if (this.modState.getMermaidItemOffer().itemTranslationKey != null) {
                Utils.displayChatInfoMessage(String.format("Mermaid Data: {%s, %d}", this.modState.getMermaidItemOffer().itemTranslationKey, this.modState.getMermaidItemOffer().quantity));
            } else {
                Utils.displayChatInfoMessage("Mermaid Data: None");
            }
            Utils.displayChatInfoMessage("Museum Length: " + this.modState.getMissingMuseumItemIds().size());
            return 1;
        })));
    }

    private void registerKeybinds() {
        openModSettings = KeyBindingHelper.registerKeyBinding((class_304)new class_304("mineboxadditions.strings.keybinds.modSettings.open", class_3675.class_307.field_1668, 79, "MineboxAdditions"));
        openAudioSettings = KeyBindingHelper.registerKeyBinding((class_304)new class_304("mineboxadditions.strings.keybinds.audioSettings.open", class_3675.class_307.field_1668, 76, "MineboxAdditions"));
        openEditMode = KeyBindingHelper.registerKeyBinding((class_304)new class_304("mineboxadditions.strings.keybinds.hudEditor.open", class_3675.class_307.field_1668, 73, "MineboxAdditions"));
        openHarvestables = KeyBindingHelper.registerKeyBinding((class_304)new class_304("mineboxadditions.strings.keybinds.harvestables.open", class_3675.class_307.field_1668, 80, "MineboxAdditions"));
        openAtlas = KeyBindingHelper.registerKeyBinding((class_304)new class_304("mineboxadditions.strings.keybinds.atlas.open", class_3675.class_307.field_1668, 344, "MineboxAdditions"));
    }
}

