/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.audio;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sound.sampled.SourceDataLine;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class AudioMixer {
    private final SourceDataLine speaker;
    Map<String, Queue<short[]>> playerQueues = new ConcurrentHashMap<String, Queue<short[]>>();
    Map<String, Queue<short[]>> playerStereoQueues = new ConcurrentHashMap<String, Queue<short[]>>();
    private final int frameSize = 960;
    private volatile boolean running = true;

    public AudioMixer(SourceDataLine speaker) {
        this.speaker = speaker;
        Thread mixingThread = new Thread(this::mixLoop);
        mixingThread.start();
    }

    public void stop() {
        this.running = false;
    }

    public void push(String playerName, short[] decodedPcm) {
        if (decodedPcm == null || decodedPcm.length != 960) {
            return;
        }
        this.playerQueues.computeIfAbsent(playerName, k -> new ConcurrentLinkedQueue()).add(decodedPcm);
    }

    public void pushStereo(String playerName, short[] stereoPcm) {
        if (stereoPcm == null || stereoPcm.length != 1920) {
            return;
        }
        short[] copy = new short[1920];
        System.arraycopy(stereoPcm, 0, copy, 0, 1920);
        this.playerStereoQueues.computeIfAbsent(playerName, k -> new ConcurrentLinkedQueue()).add(copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mixLoop() {
        byte[] outputBuffer = new byte[3840];
        long frameDurationNs = 20000000L;
        long nextFrameTime = System.nanoTime();
        while (this.running) {
            int i;
            Queue<short[]> queue;
            long now = System.nanoTime();
            if (now < nextFrameTime) {
                try {
                    Thread.sleep((nextFrameTime - now) / 1000000L, (int)((nextFrameTime - now) % 1000000L));
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            float[] mixedLeft = new float[960];
            float[] mixedRight = new float[960];
            for (Map.Entry<String, Queue<short[]>> entry : this.playerQueues.entrySet()) {
                queue = entry.getValue();
                short[] monoFrame = queue.poll();
                if (monoFrame == null || monoFrame.length != 960) continue;
                i = 0;
                while (i < 960) {
                    float sample = (float)monoFrame[i] / 32768.0f;
                    int n = i;
                    mixedLeft[n] = mixedLeft[n] + sample;
                    int n2 = i++;
                    mixedRight[n2] = mixedRight[n2] + sample;
                }
            }
            for (Map.Entry<String, Queue<short[]>> entry : this.playerStereoQueues.entrySet()) {
                queue = entry.getValue();
                short[] stereoFrame = queue.poll();
                if (stereoFrame == null || stereoFrame.length != 1920) continue;
                i = 0;
                while (i < 960) {
                    float leftSample = (float)stereoFrame[i * 2] / 32768.0f;
                    float rightSample = (float)stereoFrame[i * 2 + 1] / 32768.0f;
                    int n = i;
                    mixedLeft[n] = mixedLeft[n] + leftSample;
                    int n3 = i++;
                    mixedRight[n3] = mixedRight[n3] + rightSample;
                }
            }
            int streamCount = this.playerQueues.size() + this.playerStereoQueues.size();
            float normalization = streamCount > 1 ? 1.0f / (float)streamCount : 1.0f;
            for (int i2 = 0; i2 < 960; ++i2) {
                float left = Math.max(-1.0f, Math.min(1.0f, mixedLeft[i2] * normalization));
                float right = Math.max(-1.0f, Math.min(1.0f, mixedRight[i2] * normalization));
                short sLeft = (short)(left * 32767.0f);
                short sRight = (short)(right * 32767.0f);
                int index = i2 * 4;
                outputBuffer[index] = (byte)(sLeft & 0xFF);
                outputBuffer[index + 1] = (byte)(sLeft >> 8 & 0xFF);
                outputBuffer[index + 2] = (byte)(sRight & 0xFF);
                outputBuffer[index + 3] = (byte)(sRight >> 8 & 0xFF);
            }
            SourceDataLine sourceDataLine = this.speaker;
            synchronized (sourceDataLine) {
                this.speaker.write(outputBuffer, 0, outputBuffer.length);
            }
            nextFrameTime += frameDurationNs;
        }
    }
}

