/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.events;

import io.dampen59.mineboxadditions.ModConfig;
import io.dampen59.mineboxadditions.state.State;
import java.util.List;
import java.util.Objects;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2596;
import net.minecraft.class_642;
import net.minecraft.class_7472;

@Environment(value=EnvType.CLIENT)
public class ServerEvents {
    private static final List<String> MINEBOX_HOSTNAMES = List.of("minebox.fr", "minebox.co");
    private final State modState;

    public ServerEvents(State modState) {
        this.modState = modState;
        this.registerServerJoinEvent();
        this.registerServerLeaveEvent();
    }

    private void registerServerJoinEvent() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            class_642 serverEntry = client.method_1558();
            ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
            if (serverEntry != null) {
                String serverAddress = serverEntry.field_3761;
                if (this.isMineboxServer(serverAddress)) {
                    this.modState.setConnectedToMinebox(true);
                    this.modState.getSocket().connect();
                    if (config.autoIslandOnLogin && !this.modState.isLoginCommandSent()) {
                        Objects.requireNonNull(client.method_1562()).method_52787((class_2596)new class_7472("is"));
                        this.modState.setLoginCommandSent(true);
                    }
                } else {
                    this.modState.setConnectedToMinebox(false);
                }
            } else {
                this.modState.setConnectedToMinebox(false);
            }
        });
    }

    private void registerServerLeaveEvent() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (this.modState.getSocket().connected()) {
                this.modState.getSocket().disconnect();
                this.modState.getAudioManager().closeMicrophoneAndSpeaker();
            }
            this.modState.reset();
        });
    }

    private boolean isMineboxServer(String hostname) {
        String lowerHostname = hostname.toLowerCase();
        return MINEBOX_HOSTNAMES.stream().anyMatch(lowerHostname::contains);
    }
}

