/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.events;

import io.dampen59.mineboxadditions.MineboxAdditionsClient;
import io.dampen59.mineboxadditions.ModConfig;
import io.dampen59.mineboxadditions.hud.Hud;
import io.dampen59.mineboxadditions.state.HUDState;
import io.dampen59.mineboxadditions.state.State;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class SkyEvent {
    private final State modState;

    public SkyEvent(State prmModState) {
        this.modState = prmModState;
        this.onTick();
        HudRenderCallback.EVENT.register(this::onRenderHud);
    }

    public void onTick() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null) {
                int moonPhase = client.field_1687.method_30273();
                if (this.modState.getCurrentMoonPhase() != 0) {
                    // empty if block
                }
                this.modState.setCurrentMoonPhase(moonPhase);
            }
        });
    }

    private boolean isFullMoon() {
        return this.modState.getCurrentMoonPhase() == 0;
    }

    private void onRenderHud(class_332 context, class_9779 tickCounter) {
        Hud hud;
        String text;
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || client.field_1690.field_1842) {
            return;
        }
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        HUDState hudState = MineboxAdditionsClient.INSTANCE.modState.getHUDState();
        if (this.isFullMoon() && config.displaySettings.displayFullMoon) {
            hudState.getHud(Hud.Type.FULL_MOON).draw(context);
        }
        if (config.displaySettings.displayNextRain) {
            text = client.field_1687.method_8419() ? "Now!" : this.formatNextEventCountdown(this.modState.getWeatherState().getRainTimestamps());
            hud = hudState.getHud(Hud.Type.RAIN);
            hud.setText(class_2561.method_30163((String)text));
            hud.draw(context);
        }
        if (config.displaySettings.displayNextStorm) {
            text = client.field_1687.method_8546() ? "Now!" : this.formatNextEventCountdown(this.modState.getWeatherState().getStormTimestamps());
            hud = hudState.getHud(Hud.Type.STORM);
            hud.setText(class_2561.method_30163((String)text));
            hud.draw(context);
        }
    }

    private String formatNextEventCountdown(List<Integer> timestamps) {
        if (timestamps == null || timestamps.isEmpty()) {
            return "Unknown";
        }
        List<Integer> snapshot = SkyEvent.snapshotList(timestamps);
        if (snapshot.isEmpty()) {
            return "Unknown";
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        Integer next = null;
        for (Integer ts : snapshot) {
            if (ts == null || ts <= now || next != null && ts >= next) continue;
            next = ts;
        }
        if (next == null) {
            return "Unknown";
        }
        int secondsLeft = next - now;
        int hours = secondsLeft / 3600;
        int minutes = secondsLeft % 3600 / 60;
        int seconds = secondsLeft % 60;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private static List<Integer> snapshotList(List<Integer> src) {
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                return new ArrayList<Integer>(src);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        ArrayList<Integer> fallback = new ArrayList<Integer>();
        try {
            for (Integer i : src) {
                fallback.add(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fallback;
    }
}

