/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.events.shop;

import io.dampen59.mineboxadditions.MineboxAdditionsClient;
import io.dampen59.mineboxadditions.events.shop.Shop;
import io.dampen59.mineboxadditions.hud.Hud;
import io.dampen59.mineboxadditions.state.HUDState;
import io.dampen59.mineboxadditions.state.State;
import io.dampen59.mineboxadditions.utils.Utils;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class ShopEvent {
    private final Shop shop;
    private final State state;
    private final BooleanSupplier isAlertSent;
    private final Consumer<Boolean> setAlertSent;
    private final Supplier<String> getCurrentOffer;
    private final Consumer<String> setCurrentOffer;
    private final BooleanSupplier isConfigEnabled;
    private boolean isShopOpen = false;

    public ShopEvent(Shop shop, State state, BooleanSupplier isAlertSent, Consumer<Boolean> setAlertSent, Supplier<String> getCurrentOffer, Consumer<String> setCurrentOffer, BooleanSupplier isConfigEnabled) {
        this.shop = shop;
        this.state = state;
        this.isAlertSent = isAlertSent;
        this.setAlertSent = setAlertSent;
        this.getCurrentOffer = getCurrentOffer;
        this.setCurrentOffer = setCurrentOffer;
        this.isConfigEnabled = isConfigEnabled;
        HudRenderCallback.EVENT.register(this::onRenderHud);
        ClientTickEvents.END_CLIENT_TICK.register(this::onTick);
    }

    private void onTick(class_310 client) {
        boolean withinShopTime;
        if (!this.state.isConnectedToMinebox() || client.field_1687 == null) {
            return;
        }
        long worldTime = client.field_1687.method_8532() % 24000L;
        boolean bl = withinShopTime = worldTime >= (long)this.shop.getStartTime() && worldTime <= (long)this.shop.getStopTime();
        if (withinShopTime) {
            this.handleShopOpen();
        } else {
            this.handleShopClosed();
        }
    }

    private void handleShopOpen() {
        this.isShopOpen = true;
        if (this.isConfigEnabled.getAsBoolean() && !this.isAlertSent.getAsBoolean()) {
            this.showShopAlert();
        }
    }

    private void handleShopClosed() {
        this.isShopOpen = false;
        if (this.isAlertSent.getAsBoolean()) {
            this.setAlertSent.accept(false);
        }
        if (this.getCurrentOffer.get() != null) {
            this.setCurrentOffer.accept(null);
        }
    }

    private void showShopAlert() {
        Utils.showShopToastNotification(this.shop.name(), class_2561.method_43471((String)this.shop.getToastTitleKey()).getString(), class_2561.method_43471((String)this.shop.getToastContentKey()).getString());
        Utils.playSound(class_3417.field_17265);
        this.setAlertSent.accept(true);
    }

    private void onRenderHud(class_332 context, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        if (client.field_1690.field_1842 || client.field_1724 == null) {
            return;
        }
        HUDState hudState = MineboxAdditionsClient.INSTANCE.modState.getHUDState();
        Hud hud = hudState.getHud(Hud.Type.SHOP);
        String offer = this.getCurrentOffer.get();
        if (offer != null) {
            hud.setText(class_2561.method_30163((String)offer));
            hud.draw(context);
        } else if (this.isShopOpen) {
            hud.setText((class_2561)class_2561.method_43471((String)this.shop.getToastTitleKey()));
            hud.draw(context);
        }
    }
}

