/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.events.shop;

import io.dampen59.mineboxadditions.ModConfig;
import io.dampen59.mineboxadditions.events.shop.Shop;
import io.dampen59.mineboxadditions.events.shop.ShopEvent;
import io.dampen59.mineboxadditions.state.OfferState;
import io.dampen59.mineboxadditions.state.State;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ShopEventManager {
    public ShopEventManager(State modState) {
        OfferState offers = modState.getOfferState();
        this.registerShopEvent(Shop.BAKERY, modState, offers::isBakeryAlertSent, offers::setBakeryAlertSent, offers::getBakeryOffer, offers::setBakeryOffer, () -> ((ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig()).shopsAlertsSettings.getBakeryAlerts);
        this.registerShopEvent(Shop.BUCKSTAR, modState, offers::isBuckstarAlertSent, offers::setBuckstarAlertSent, offers::getBuckstarOffer, offers::setBuckstarOffer, () -> ((ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig()).shopsAlertsSettings.getBuckstarAlerts);
        this.registerShopEvent(Shop.COCKTAIL, modState, offers::isCocktailAlertSent, offers::setCocktailAlertSent, offers::getCocktailOffer, offers::setCocktailOffer, () -> ((ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig()).shopsAlertsSettings.getCocktailAlerts);
        this.registerShopEvent(Shop.MOUSE, modState, offers::isMouseAlertSent, offers::setMouseAlertSent, offers::getMouseOffer, offers::setMouseOffer, () -> ((ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig()).shopsAlertsSettings.getMouseAlerts);
    }

    private void registerShopEvent(Shop shop, State modState, BooleanSupplier isAlertSent, Consumer<Boolean> setAlertSent, Supplier<String> getOffer, Consumer<String> setOffer, BooleanSupplier isConfigEnabled) {
        new ShopEvent(shop, modState, isAlertSent, setAlertSent, getOffer, setOffer, isConfigEnabled);
    }
}

