/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.gui;

import io.dampen59.mineboxadditions.MineboxAdditionsClient;
import io.dampen59.mineboxadditions.ModConfig;
import io.dampen59.mineboxadditions.hud.Hud;
import io.dampen59.mineboxadditions.state.HUDState;
import java.awt.Rectangle;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class HudEditorScreen
extends class_437 {
    private Hud.Type dragging = null;
    private int offsetX;
    private int offsetY;
    private static final int PADDING = 2;

    public HudEditorScreen() {
        super(class_2561.method_30163((String)"HUD Editor"));
    }

    private boolean isInBounds(double mouseX, double mouseY, int x, int y, int w, int h) {
        return mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            HUDState hudState = MineboxAdditionsClient.INSTANCE.modState.getHUDState();
            for (Map.Entry<Hud.Type, Hud> entry : hudState.getHuds().entrySet()) {
                int hudY;
                Hud hud = entry.getValue();
                int hudX = hud.getX();
                if (!this.isInBounds(mouseX, mouseY, hudX, hudY = hud.getY(), hud.getWidth(), hud.getHeight())) continue;
                this.dragging = entry.getKey();
                this.offsetX = (int)mouseX - hudX;
                this.offsetY = (int)mouseY - hudY;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging != null) {
            boolean collisionOccurred;
            HUDState hudState = MineboxAdditionsClient.INSTANCE.modState.getHUDState();
            Hud hud = hudState.getHud(this.dragging);
            int nextX = (int)mouseX - this.offsetX;
            int nextY = (int)mouseY - this.offsetY;
            nextX = Math.max(4, nextX);
            nextX = Math.min(this.field_22789 - hud.getWidth() - 4, nextX);
            nextY = Math.max(4, nextY);
            nextY = Math.min(this.field_22790 - hud.getHeight() - 4, nextY);
            int iterations = 0;
            do {
                collisionOccurred = false;
                Rectangle hudBounds = new Rectangle(nextX, nextY, hud.getWidth(), hud.getHeight());
                for (Map.Entry<Hud.Type, Hud> entry : hudState.getHuds().entrySet()) {
                    double overlapY;
                    Hud otherHud;
                    Rectangle otherBounds;
                    if (entry.getKey() == this.dragging || !hudBounds.intersects(otherBounds = new Rectangle((otherHud = entry.getValue()).getX() - 2, otherHud.getY() - 2, otherHud.getWidth() + 4, otherHud.getHeight() + 4))) continue;
                    collisionOccurred = true;
                    double overlapX = (double)hudBounds.width / 2.0 + (double)otherBounds.width / 2.0 - Math.abs(hudBounds.getCenterX() - otherBounds.getCenterX());
                    if (overlapX < (overlapY = (double)hudBounds.height / 2.0 + (double)otherBounds.height / 2.0 - Math.abs(hudBounds.getCenterY() - otherBounds.getCenterY()))) {
                        nextX = hudBounds.getCenterX() < otherBounds.getCenterX() ? (int)((double)nextX - overlapX) : (int)((double)nextX + overlapX);
                    } else {
                        nextY = hudBounds.getCenterY() < otherBounds.getCenterY() ? (int)((double)nextY - overlapY) : (int)((double)nextY + overlapY);
                    }
                    hudBounds.setLocation(nextX, nextY);
                }
            } while (collisionOccurred && ++iterations < 10);
            int screenCenterX = this.field_22789 / 2;
            if (this.dragging == Hud.Type.ITEM_PICKUP && nextX > screenCenterX) {
                hud.setX(nextX + hud.getWidth());
            } else {
                hud.setX(nextX);
            }
            hud.setY(nextY);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.dragging != null) {
            this.dragging = null;
            AutoConfig.getConfigHolder(ModConfig.class).save();
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        HUDState hudState = MineboxAdditionsClient.INSTANCE.modState.getHUDState();
        for (Hud hud : hudState.getHuds().values()) {
            hud.draw(context);
        }
    }

    public boolean method_25421() {
        return false;
    }
}

