/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.minebox;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dampen59.mineboxadditions.MineboxAdditionsClient;
import io.dampen59.mineboxadditions.gui.components.ItemListWidget;
import io.dampen59.mineboxadditions.minebox.MineboxStat;
import io.dampen59.mineboxadditions.utils.RaritiesUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class MineboxItem {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="level")
    private int level;
    @JsonProperty(value="category")
    private String category;
    @JsonProperty(value="rarity")
    private String rarity;
    @JsonProperty(value="texture")
    private String texture;
    @JsonProperty(value="mbxStats")
    private Map<String, MineboxStat> mbxStats;
    @JsonProperty(value="recipe")
    private Recipe recipe;

    public String getId() {
        return this.id;
    }

    public int getLevel() {
        return this.level;
    }

    public String getCategory() {
        return this.category;
    }

    public String getRarity() {
        return this.rarity;
    }

    public String getTexture() {
        return this.texture;
    }

    public Map<String, MineboxStat> getMbxStats() {
        return this.mbxStats;
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    public static String getLoreText(String itemId) {
        String key;
        StringBuilder loreBuilder = new StringBuilder();
        class_2477 language = class_2477.method_10517();
        int index = 0;
        while (language.method_4678(key = "mbx.items." + itemId + ".lore." + index)) {
            String raw = class_2561.method_43471((String)key).getString();
            String cleaned = raw.replaceAll("[\\p{Cntrl}&&[^\r\n\t]]", "").replaceAll("[\\r\\n\\t]", " ");
            if (index > 0) {
                loreBuilder.append(" ");
            }
            loreBuilder.append(cleaned.trim());
            ++index;
        }
        return loreBuilder.toString();
    }

    public static class_2561 getDisplayName(MineboxItem item) {
        String mob;
        String resource;
        String id = item.getId();
        String rarity = item.getRarity().toLowerCase();
        class_2477 lang = class_2477.method_10517();
        Function<class_2561, class_2561> styled = base -> base.method_27661().method_27694(style -> style.method_36139(RaritiesUtils.getRarityColor(rarity).getRGB()).method_10982(Boolean.valueOf(true)));
        String nameKey = "mbx.items." + id + ".name";
        if (lang.method_4678(nameKey)) {
            return MineboxItem.styled((class_2561)class_2561.method_43471((String)nameKey), item.rarity.toLowerCase());
        }
        if (id.matches("candy_enchanted_.*")) {
            return MineboxItem.formatStatName("mbx.items.candies_enchanted.name", id, styled);
        }
        if (id.matches("candy_.*")) {
            return MineboxItem.formatStatName("mbx.items.candies_big.name", id, styled);
        }
        if (id.startsWith("rune_small")) {
            return MineboxItem.formatStatName("mbx.items.runes_small.name", id, styled);
        }
        if (id.startsWith("rune_big")) {
            return MineboxItem.formatStatName("mbx.items.runes_big.name", id, styled);
        }
        if (id.startsWith("rune_enchanted")) {
            return MineboxItem.formatStatName("mbx.items.runes_enchanted.name", id, styled);
        }
        if (id.startsWith("scroll_small")) {
            return MineboxItem.formatStatName("mbx.items.scrolls_small.name", id, styled);
        }
        if (id.startsWith("scroll_big")) {
            return MineboxItem.formatStatName("mbx.items.scrolls_big.name", id, styled);
        }
        if (id.startsWith("scroll_enchanted")) {
            return MineboxItem.formatStatName("mbx.items.scrolls_enchanted.name", id, styled);
        }
        Map<String, String> containers = Map.of("transformed_", "mbx.items.container.transformed", "bag_", "mbx.items.container.bag", "crate_", "mbx.items.container.crate", "barrel_", "mbx.items.container.barrel", "enchanted_", "mbx.items.container.enchanted");
        for (Map.Entry<String, String> entry : containers.entrySet()) {
            if (!id.startsWith(entry.getKey())) continue;
            String resource2 = id.substring(entry.getKey().length());
            return MineboxItem.styled((class_2561)class_2561.method_43469((String)entry.getValue(), (Object[])new Object[]{MineboxItem.resolveResource(resource2)}), item.rarity.toLowerCase());
        }
        if (id.startsWith("harvester_")) {
            if (id.endsWith("_reaper")) {
                resource = id.substring("harvester_".length(), id.length() - "_reaper".length());
                return MineboxItem.styled((class_2561)class_2561.method_43469((String)"mbx.items.reaper.name", (Object[])new Object[]{MineboxItem.resolveResource(resource)}), item.rarity.toLowerCase());
            }
            if (id.endsWith("_chopper")) {
                resource = id.substring("harvester_".length(), id.length() - "_chopper".length());
                return MineboxItem.styled((class_2561)class_2561.method_43469((String)"mbx.items.chopper.name", (Object[])new Object[]{MineboxItem.resolveResource(resource)}), item.rarity.toLowerCase());
            }
            resource = id.substring("harvester_".length());
            return MineboxItem.styled((class_2561)class_2561.method_43469((String)"mbx.items.harvester.name", (Object[])new Object[]{MineboxItem.resolveResource(resource)}), item.rarity.toLowerCase());
        }
        if (id.startsWith("owner_remover_")) {
            String rarityKey = id.substring("owner_remover_".length());
            class_5250 rarityText = class_2561.method_43471((String)("mbx.rarities." + rarityKey + ".title"));
            return MineboxItem.styled((class_2561)class_2561.method_43469((String)"mbx.items.owner_remover.name", (Object[])new Object[]{rarityText.getString()}), item.rarity.toLowerCase());
        }
        if (id.startsWith("haversack_small_")) {
            resource = id.substring("haversack_small_".length());
            return MineboxItem.styled((class_2561)class_2561.method_43469((String)"mbx.items.haversack_small.name", (Object[])new Object[]{MineboxItem.resolveResource(resource)}), item.rarity.toLowerCase());
        }
        if (id.startsWith("haversack_")) {
            resource = id.substring("haversack_".length());
            return MineboxItem.styled((class_2561)class_2561.method_43469((String)"mbx.items.haversack.name", (Object[])new Object[]{MineboxItem.resolveResource(resource)}), item.rarity.toLowerCase());
        }
        if (id.startsWith("spawner_")) {
            mob = id.substring("spawner_".length());
            return MineboxItem.styled((class_2561)class_2561.method_43469((String)"mbx.items.spawner.name", (Object[])new Object[]{MineboxItem.resolveEntity(mob)}), item.rarity.toLowerCase());
        }
        if (id.startsWith("soul_")) {
            mob = id.substring("soul_".length());
            return MineboxItem.styled((class_2561)class_2561.method_43469((String)"mbx.items.soul.name", (Object[])new Object[]{MineboxItem.resolveEntity(mob)}), item.rarity.toLowerCase());
        }
        return class_2561.method_43470((String)id).method_27661().method_27694(style -> style.method_36139(-1));
    }

    private static class_2561 statName(String formatKey, String id, Function<class_2561, class_2561> styleFunc) {
        return MineboxItem.statName(formatKey, id, styleFunc, "mbx.stats.");
    }

    private static class_2561 statName(String formatKey, String id, Function<class_2561, class_2561> styleFunc, String statPrefix) {
        String stat = id.substring(id.lastIndexOf(95) + 1);
        class_5250 translatedStat = class_2561.method_43471((String)(statPrefix + stat));
        return styleFunc.apply((class_2561)class_2561.method_43469((String)formatKey, (Object[])new Object[]{translatedStat.getString()}));
    }

    private static String capitalize(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    private static class_2561 formatStatName(String key, String id, Function<class_2561, class_2561> styledFunc) {
        return MineboxItem.formatStatName(key, id, styledFunc, "mbx.stats.");
    }

    private static class_2561 formatStatName(String key, String id, Function<class_2561, class_2561> styledFunc, String statPrefix) {
        String stat = id.substring(id.lastIndexOf(95) + 1);
        class_5250 translatedStat = class_2561.method_43471((String)(statPrefix + stat));
        return styledFunc.apply((class_2561)class_2561.method_43469((String)key, (Object[])new Object[]{translatedStat.getString()}));
    }

    private static class_2561 resolveResource(String target) {
        class_2477 lang = class_2477.method_10517();
        if (lang.method_4678("block.minecraft." + target)) {
            return class_2561.method_43471((String)("block.minecraft." + target));
        }
        if (lang.method_4678("item.minecraft." + target)) {
            return class_2561.method_43471((String)("item.minecraft." + target));
        }
        return class_2561.method_30163((String)target);
    }

    private static class_2561 resolveEntity(String name) {
        class_2477 lang = class_2477.method_10517();
        if (lang.method_4678("entity.minecraft." + name)) {
            return class_2561.method_43471((String)("entity.minecraft." + name));
        }
        return class_2561.method_30163((String)name);
    }

    public Optional<MineboxStat> getStat(String statName) {
        return this.mbxStats == null ? Optional.empty() : Optional.ofNullable(this.mbxStats.get(statName));
    }

    private static class_2561 styled(class_2561 base, String rarity) {
        return base.method_27661().method_27694(style -> style.method_36139(RaritiesUtils.getRarityColor(rarity.toLowerCase()).getRGB()).method_10982(Boolean.valueOf(true)));
    }

    @Environment(value=EnvType.CLIENT)
    public static class Recipe {
        @JsonProperty(value="job")
        private String job;
        @JsonProperty(value="ingredients")
        private List<Ingredient> ingredients;

        public String getJob() {
            return this.job;
        }

        public List<Ingredient> getIngredients() {
            return this.ingredients;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Ingredient {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="amount")
        private int amount;

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public int getAmount() {
            return this.amount;
        }

        public boolean isVanilla() {
            return "vanilla".equalsIgnoreCase(this.type);
        }

        public class_2561 getDisplayName() {
            if (this.isVanilla()) {
                class_2960 vanillaId = class_2960.method_60655((String)"minecraft", (String)this.id);
                if (class_7923.field_41178.method_10250(vanillaId)) {
                    class_1792 vanillaItem = (class_1792)class_7923.field_41178.method_63535(vanillaId);
                    return vanillaItem.method_63680();
                }
                return class_2561.method_43471((String)("item.minecraft." + this.id));
            }
            MineboxItem item = MineboxAdditionsClient.INSTANCE.modState.getItemById(this.id);
            return item != null ? MineboxItem.getDisplayName(item) : class_2561.method_43470((String)this.id);
        }

        public String getTranslationKey() {
            return "mbx.items." + this.id + ".name";
        }

        public class_2960 getTexture() {
            if (this.isVanilla()) {
                class_2960 vanillaId = class_2960.method_60655((String)"minecraft", (String)this.id);
                if (class_7923.field_41178.method_10250(vanillaId)) {
                    return class_2960.method_60655((String)"minecraft", (String)("textures/item/" + this.id + ".png"));
                }
                return class_2960.method_60655((String)"minecraft", (String)("textures/item/" + this.id + ".png"));
            }
            MineboxItem item = MineboxAdditionsClient.INSTANCE.modState.getItemById(this.id);
            return item != null ? ItemListWidget.ItemEntry.getTexture(item.getId()) : null;
        }

        public MineboxItem getCustomItem() {
            return this.isVanilla() ? null : MineboxAdditionsClient.INSTANCE.modState.getItemById(this.id);
        }

        public class_1799 getVanillaStack() {
            if (!this.isVanilla()) {
                return class_1799.field_8037;
            }
            try {
                class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)this.id));
                return new class_1799((class_1935)item);
            }
            catch (Exception e) {
                return class_1799.field_8037;
            }
        }
    }
}

