/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.mixin.client;

import io.dampen59.mineboxadditions.MineboxAdditionsClient;
import io.dampen59.mineboxadditions.ModConfig;
import io.dampen59.mineboxadditions.utils.RaritiesUtils;
import io.dampen59.mineboxadditions.utils.Utils;
import java.awt.Color;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_465.class})
public abstract class InventoryScreenMixin
extends class_437 {
    protected InventoryScreenMixin() {
        super(null);
    }

    @Inject(method={"renderMain"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/HandledScreen;drawSlots(Lnet/minecraft/client/gui/DrawContext;)V", shift=At.Shift.BEFORE)})
    private void renderRarityBackgroundsUnderItems(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        ModConfig cfg = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        if (!cfg.displaySettings.itemRaritySettings.displayItemsRarity) {
            return;
        }
        class_465 screen = (class_465)this;
        for (class_1735 slot : screen.method_17577().field_7761) {
            Color rarity;
            class_1799 stack;
            if (!slot.method_7682() || !slot.method_7681() || !Utils.isMineboxItem(stack = slot.method_7677()) || (rarity = RaritiesUtils.getItemRarityColorFromLore(stack)) == null) continue;
            int argb = rarity.getRGB();
            if (cfg.displaySettings.itemRaritySettings.displayMode == ModConfig.RaritiesDisplayMode.CIRCLE) {
                InventoryScreenMixin.drawCircle(context, slot.field_7873, slot.field_7872, argb);
                continue;
            }
            if (cfg.displaySettings.itemRaritySettings.displayMode != ModConfig.RaritiesDisplayMode.FILL) continue;
            context.method_25294(slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, argb);
        }
    }

    private static void drawCircle(class_332 ctx, int x, int y, int argb) {
        int cx = x + 8;
        int cy = y + 8;
        int r = 8;
        for (int dy = -r; dy <= r; ++dy) {
            int dx = (int)Math.sqrt(r * r - dy * dy);
            ctx.method_25294(cx - dx, cy + dy, cx + dx + 1, cy + dy + 1, argb);
        }
    }

    @Inject(method={"renderMain"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/HandledScreen;drawSlots(Lnet/minecraft/client/gui/DrawContext;)V", shift=At.Shift.AFTER)})
    private void renderMissingMuseumItemsBorder(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        ModConfig cfg = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        if (!cfg.displaySettings.displayMuseumMissingItems) {
            return;
        }
        class_465 screen = (class_465)this;
        if (MineboxAdditionsClient.INSTANCE.modState == null) {
            return;
        }
        List<String> missing = MineboxAdditionsClient.INSTANCE.modState.getMissingMuseumItemIds();
        if (missing == null || missing.isEmpty()) {
            return;
        }
        float hueOffset = (float)(System.currentTimeMillis() % 6000L) / 6000.0f;
        for (class_1735 slot : screen.method_17577().field_7761) {
            String id;
            class_1799 stack;
            if (!slot.method_7682() || !slot.method_7681() || !Utils.isMineboxItem(stack = slot.method_7677()) || (id = Utils.getMineboxItemId(stack)) == null || id.isEmpty() || !missing.contains(id)) continue;
            InventoryScreenMixin.drawMuseumBorder(context, slot.field_7873, slot.field_7872, hueOffset);
        }
    }

    private static void drawMuseumBorder(class_332 ctx, int x, int y, float hueOffset) {
        int top = InventoryScreenMixin.hsvToArgb((hueOffset + 0.0f) % 1.0f);
        int right = InventoryScreenMixin.hsvToArgb((hueOffset + 0.25f) % 1.0f);
        int bottom = InventoryScreenMixin.hsvToArgb((hueOffset + 0.5f) % 1.0f);
        int left = InventoryScreenMixin.hsvToArgb((hueOffset + 0.75f) % 1.0f);
        ctx.method_25294(x, y, x + 16, y + 1, top);
        ctx.method_25294(x + 16 - 1, y, x + 16, y + 16, right);
        ctx.method_25294(x, y + 16 - 1, x + 16, y + 16, bottom);
        ctx.method_25294(x, y, x + 1, y + 16, left);
    }

    private static int hsvToArgb(float hue) {
        int rgb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
        return 0xFF000000 | rgb & 0xFFFFFF;
    }
}

