/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.network;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.maxhenkel.opus4j.OpusDecoder;
import io.dampen59.mineboxadditions.MineboxAdditionsClient;
import io.dampen59.mineboxadditions.ModConfig;
import io.dampen59.mineboxadditions.audio.AudioManager;
import io.dampen59.mineboxadditions.minebox.MineboxFishingShoal;
import io.dampen59.mineboxadditions.minebox.MineboxHarvestable;
import io.dampen59.mineboxadditions.minebox.MineboxItem;
import io.dampen59.mineboxadditions.state.State;
import io.dampen59.mineboxadditions.utils.AudioUtils;
import io.dampen59.mineboxadditions.utils.ImageUtils;
import io.dampen59.mineboxadditions.utils.Utils;
import io.socket.client.IO;
import io.socket.client.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import org.json.JSONArray;

@Environment(value=EnvType.CLIENT)
public class SocketManager {
    private final State modState;
    private final int protocolVersion = 10;
    private final ObjectMapper mapper = new ObjectMapper();

    public SocketManager(State modState) {
        this.modState = modState;
        this.initializeSocket();
    }

    private void initializeSocket() {
        ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        URI uri = URI.create(config.socketServerAddress);
        IO.Options options = IO.Options.builder().build();
        Socket socket = IO.socket((URI)uri, (IO.Options)options);
        this.modState.setSocket(socket);
        socket.on("connect", args -> {
            class_310 client = class_310.method_1551();
            if (client != null && client.field_1724 != null) {
                String playerName = client.field_1724.method_5477().getString();
                String playerUuid = client.field_1724.method_5667().toString();
                String playerLang = client.method_1526().method_4669();
                socket.emit("C2SHelloConnectMessage", new Object[]{playerUuid, playerName, playerLang, 10});
            }
        });
        socket.on("S2CShopOfferEvent", args -> {
            String shopName = (String)args[0];
            String itemName = (String)args[1];
            switch (shopName) {
                case "Mouse": {
                    if (this.modState.getOfferState().getMouseOffer() != null) break;
                    String title = class_2561.method_43471((String)"mineboxadditions.strings.toasts.shop.mouse.iteminfo.title").getString();
                    this.modState.getOfferState().setMouseOffer(title + ": " + class_2561.method_43471((String)itemName).getString());
                    Utils.showShopToastNotification("MOUSE", title, class_2561.method_43469((String)"mineboxadditions.strings.toasts.shop.mouse.iteminfo.content", (Object[])new Object[]{class_2561.method_43471((String)itemName).getString()}).getString());
                    Utils.playSound(class_3417.field_17265);
                    break;
                }
                case "Bakery": {
                    if (this.modState.getOfferState().getBakeryOffer() != null) break;
                    String title = class_2561.method_43471((String)"mineboxadditions.strings.toasts.shop.bakery.iteminfo.title").getString();
                    this.modState.getOfferState().setBakeryOffer(title + ": " + class_2561.method_43471((String)itemName).getString());
                    Utils.showShopToastNotification("BAKERY", title, class_2561.method_43469((String)"mineboxadditions.strings.toasts.shop.bakery.iteminfo.content", (Object[])new Object[]{class_2561.method_43471((String)itemName).getString()}).getString());
                    Utils.playSound(class_3417.field_17265);
                    break;
                }
                case "Buckstar": {
                    if (this.modState.getOfferState().getBuckstarOffer() != null) break;
                    String title = class_2561.method_43471((String)"mineboxadditions.strings.toasts.shop.buckstar.iteminfo.title").getString();
                    this.modState.getOfferState().setBuckstarOffer(title + ": " + class_2561.method_43471((String)itemName).getString());
                    Utils.showShopToastNotification("BUCKSTAR", title, class_2561.method_43469((String)"mineboxadditions.strings.toasts.shop.buckstar.iteminfo.content", (Object[])new Object[]{class_2561.method_43471((String)itemName).getString()}).getString());
                    Utils.playSound(class_3417.field_17265);
                    break;
                }
                case "Cocktail": {
                    if (this.modState.getOfferState().getCocktailOffer() != null) break;
                    String title = class_2561.method_43471((String)"mineboxadditions.strings.toasts.shop.cocktail.iteminfo.title").getString();
                    this.modState.getOfferState().setCocktailOffer(title + ": " + class_2561.method_43471((String)itemName).getString());
                    Utils.showShopToastNotification("COCKTAIL", title, class_2561.method_43469((String)"mineboxadditions.strings.toasts.shop.cocktail.iteminfo.content", (Object[])new Object[]{class_2561.method_43471((String)itemName).getString()}).getString());
                    Utils.playSound(class_3417.field_17265);
                    break;
                }
                default: {
                    System.out.println("[SocketManager] Unknown shop event: " + shopName + " Data: " + Arrays.toString(args));
                }
            }
        });
        socket.on("S2CProtocolMismatch", args -> Utils.showToastNotification(class_2561.method_43471((String)"mineboxadditions.strings.update.title").getString(), class_2561.method_43471((String)"mineboxadditions.strings.update.content").getString()));
        socket.on("S2CMineboxItemsStats", args -> {
            String jsonData = (String)args[0];
            try {
                List items = (List)this.mapper.readValue(jsonData, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, MineboxItem.class));
                this.modState.setMbxItems(items);
            }
            catch (JsonProcessingException e) {
                System.out.println("[SocketManager] Failed to load Minebox Items Stats JSON: " + e.getMessage());
            }
        });
        socket.on("S2CMineboxFishables", args -> {
            String jsonData = (String)args[0];
            try {
                List items = (List)this.mapper.readValue(jsonData, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, MineboxFishingShoal.FishingShoalFish.class));
                for (MineboxFishingShoal.FishingShoalFish fish : items) {
                    if (fish.getTexture() == null) {
                        MineboxAdditionsClient.LOGGER.warn("Fish {} has null texture data", (Object)fish.getName());
                        continue;
                    }
                    String textureName = "textures/fish/" + fish.getName() + ".png";
                    class_2960 resource = ImageUtils.createTextureFromBase64(fish.getTexture(), textureName);
                    if (resource == null) continue;
                    fish.setResource(resource);
                }
                this.modState.setMbxFishables(items);
            }
            catch (JsonProcessingException e) {
                MineboxAdditionsClient.LOGGER.error("[SocketManager] Failed to load Minebox Fishables JSON: {}", (Object)(e.getMessage() + "\n" + Arrays.toString(e.getStackTrace())));
            }
        });
        socket.on("S2CShinyEvent", args -> {
            String playerName = (String)args[0];
            String mobKey = (String)args[1];
            String mobUuid = (String)args[2];
            this.modState.getMbxShiniesUuids().put(mobUuid, true);
            String mobName = class_2561.method_43471((String)mobKey).getString();
            Utils.shinyFoundAlert(playerName, mobName);
        });
        socket.on("S2CAudioData", args -> {
            String playerName = (String)args[0];
            byte[] audioData = (byte[])args[1];
            try {
                OpusDecoder decoder = this.modState.getAudioManager().getDecoders().computeIfAbsent(playerName, name -> {
                    try {
                        return new OpusDecoder(48000, 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                });
                if (decoder == null) {
                    return;
                }
                AudioUtils.playAudio(decoder, audioData, playerName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        socket.on("S2CHarvestableData", args -> {
            String islandName = (String)args[0];
            String jsonData = (String)args[1];
            try {
                List items = (List)this.mapper.readValue(jsonData, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, MineboxHarvestable.class));
                this.modState.addMineboxHarvestables(islandName, items);
            }
            catch (Exception e) {
                System.out.println("[SocketManager] Failed to load Harvestables JSON: " + e.getMessage());
            }
        });
        socket.on("S2CProximityAudioData", args -> {
            String playerName = (String)args[0];
            byte[] audioData = (byte[])args[1];
            try {
                class_1657 sourcePlayer = AudioUtils.getNearbyPlayer(playerName);
                if (sourcePlayer == null) {
                    return;
                }
                float volumeMultiplier = AudioUtils.computeVolumeMultiplier(sourcePlayer);
                OpusDecoder decoder = this.modState.getAudioManager().getDecoders().computeIfAbsent(playerName, name -> {
                    try {
                        return new OpusDecoder(48000, 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                });
                if (decoder == null) {
                    return;
                }
                AudioUtils.playProximityAudio(decoder, audioData, volumeMultiplier, sourcePlayer, playerName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        socket.on("S2CAudioRoomCreated", args -> {
            String roomCode = (String)args[0];
            Utils.displayChatSuccessMessage(class_2561.method_43469((String)"mineboxadditions.strings.audiochannel.create.success", (Object[])new Object[]{roomCode}).getString());
            try {
                AudioManager audioManager = this.modState.getAudioManager();
                Mixer speakerMixer = AudioUtils.getMixerByName(MineboxAdditionsClient.INSTANCE.config.selectedSpeakerName);
                if (speakerMixer != null) {
                    audioManager.openSpeaker(speakerMixer);
                } else {
                    audioManager.openSpeaker();
                }
                Mixer micMixer = AudioUtils.getMixerByName(MineboxAdditionsClient.INSTANCE.config.selectedMicName);
                if (micMixer != null) {
                    audioManager.openMicrophone(micMixer);
                } else {
                    audioManager.openMicrophone();
                }
            }
            catch (LineUnavailableException e) {
                this.modState.getSocket().emit("C2SLeaveAudioRoom", new Object[0]);
                Utils.displayChatErrorMessage("You have left the voice channel because MineboxAdditions was not able to setup your Speakers and/or Microphone. Please check your game logs.");
                MineboxAdditionsClient.LOGGER.error("[SocketManager] Failed to open Speaker or Microphone : {}", (Object)e.getMessage());
            }
        });
        socket.on("S2CAudioRoomJoined", args -> {
            String roomCode = (String)args[0];
            Utils.displayChatSuccessMessage(class_2561.method_43469((String)"mineboxadditions.strings.audiochannel.join.success", (Object[])new Object[]{roomCode}).getString());
            try {
                AudioManager audioManager = this.modState.getAudioManager();
                Mixer speakerMixer = AudioUtils.getMixerByName(MineboxAdditionsClient.INSTANCE.config.selectedSpeakerName);
                if (speakerMixer != null) {
                    audioManager.openSpeaker(speakerMixer);
                } else {
                    audioManager.openSpeaker();
                }
                Mixer micMixer = AudioUtils.getMixerByName(MineboxAdditionsClient.INSTANCE.config.selectedMicName);
                if (micMixer != null) {
                    audioManager.openMicrophone(micMixer);
                } else {
                    audioManager.openMicrophone();
                }
            }
            catch (LineUnavailableException e) {
                this.modState.getSocket().emit("C2SLeaveAudioRoom", new Object[0]);
                Utils.displayChatErrorMessage("You have left the voice channel because MineboxAdditions was not able to setup your Speakers and/or Microphone. Please check your game logs.");
                MineboxAdditionsClient.LOGGER.error("[SocketManager] Failed to open Speaker or Microphone : {}", (Object)e.getMessage());
            }
        });
        socket.on("S2CProximityAudioToggled", args -> {
            block8: {
                boolean isEnabled = (Boolean)args[0];
                if (isEnabled) {
                    Utils.displayChatSuccessMessage(class_2561.method_43471((String)"mineboxadditions.strings.audiochannel.proximity.enabled").getString());
                    AudioManager audioManager = this.modState.getAudioManager();
                    try {
                        if (audioManager.getSpeaker() == null || !audioManager.getSpeaker().isOpen()) {
                            Mixer speakerMixer = AudioUtils.getMixerByName(MineboxAdditionsClient.INSTANCE.config.selectedSpeakerName);
                            if (speakerMixer != null) {
                                audioManager.openSpeaker(speakerMixer);
                            } else {
                                audioManager.openSpeaker();
                            }
                        }
                        if (audioManager.getMicrophone() != null && audioManager.getMicrophone().isOpen()) break block8;
                        Mixer micMixer = AudioUtils.getMixerByName(MineboxAdditionsClient.INSTANCE.config.selectedMicName);
                        if (micMixer != null) {
                            audioManager.openMicrophone(micMixer);
                            break block8;
                        }
                        audioManager.openMicrophone();
                    }
                    catch (LineUnavailableException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.modState.getAudioManager().closeMicrophoneAndSpeaker();
                    Utils.displayChatErrorMessage(class_2561.method_43471((String)"mineboxadditions.strings.audiochannel.proximity.disabled").getString());
                }
            }
        });
        socket.on("S2CJoinAudioRoomFailed", args -> {
            String roomCode = (String)args[0];
            Utils.displayChatErrorMessage(class_2561.method_43469((String)"mineboxadditions.strings.audiochannel.join.failed", (Object[])new Object[]{roomCode}).getString());
        });
        socket.on("S2CAudioRoomCreationFailed", args -> Utils.displayChatErrorMessage(class_2561.method_43471((String)"mineboxadditions.strings.audiochannel.create.failed").getString()));
        socket.on("S2CAudioClientConnected", args -> {
            String playerName = (String)args[0];
            Utils.displayChatInfoMessage(class_2561.method_43469((String)"mineboxadditions.strings.audiochannel.user.connected", (Object[])new Object[]{playerName}).getString());
        });
        socket.on("S2CLeaveAudioRoomFailed", args -> Utils.displayChatErrorMessage(class_2561.method_43471((String)"mineboxadditions.strings.audiochannel.leave.failed").getString()));
        socket.on("S2CEnableProximityAudioFailedLeaveFirst", args -> Utils.displayChatErrorMessage(class_2561.method_43471((String)"mineboxadditions.strings.audiochannel.proximity.enable.fail.leavefirst").getString()));
        socket.on("S2CCreateJoinAudioRoomFailedDisableProximityFirst", args -> Utils.displayChatErrorMessage(class_2561.method_43471((String)"mineboxadditions.strings.audiochannel.join.fail.leavefirst").getString()));
        socket.on("S2CAudioRoomLeft", args -> {
            String roomCode = (String)args[0];
            Utils.displayChatSuccessMessage(class_2561.method_43469((String)"mineboxadditions.strings.audiochannel.leave.success", (Object[])new Object[]{roomCode}).getString());
            this.modState.getAudioManager().closeMicrophoneAndSpeaker();
        });
        socket.on("S2CAudioClientDisconnected", args -> {
            String playerName = (String)args[0];
            Utils.displayChatInfoMessage(class_2561.method_43469((String)"mineboxadditions.strings.audiochannel.user.disconnected", (Object[])new Object[]{playerName}).getString());
        });
        socket.on("S2CWeatherData", args -> {
            String weather = (String)args[0];
            Integer timestamp = Integer.parseInt(args[1].toString());
            switch (weather) {
                case "RAIN": {
                    this.modState.getWeatherState().addRainTimestamp(timestamp);
                    break;
                }
                case "STORM": {
                    this.modState.getWeatherState().addRainTimestamp(timestamp);
                    this.modState.getWeatherState().addStormTimestamp(timestamp);
                    break;
                }
                default: {
                    System.out.println("Received unknown weather data : " + weather);
                }
            }
        });
        socket.on("S2ClearWeatherData", args -> this.modState.getWeatherState().clear());
        socket.on("S2CMotd", args -> {
            String message = (String)args[0];
            Utils.displayChatInfoMessage("[MineboxAdditions MOTD] " + message);
        });
        socket.on("S2CMermaidRequest", args -> {
            int itemQuantity = (Integer)args[0];
            String itemTranslationKey = (String)args[1];
            String itemTranslationKeyArgs = args[2] instanceof String ? (String)args[2] : null;
            this.modState.getMermaidItemOffer().set(itemQuantity, itemTranslationKey, itemTranslationKeyArgs);
        });
        socket.on("S2CMineboxApiUnauthorized", args -> Utils.displayChatErrorMessage(class_2561.method_43471((String)"mineboxadditions.strings.errors.unauthorized-api").getString()));
        socket.on("S2CMissingMuseumItems", args -> {
            ArrayList<String> itemIds = new ArrayList<String>();
            Object payload = args[0];
            JSONArray arr = (JSONArray)payload;
            for (int i = 0; i < arr.length(); ++i) {
                String id = arr.optString(i, null);
                if (id == null || id.isEmpty()) continue;
                itemIds.add(id);
            }
            this.modState.setMissingMuseumItemIds(itemIds);
        });
    }
}

