/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.utils;

import io.dampen59.mineboxadditions.minebox.MineboxItem;
import io.dampen59.mineboxadditions.minebox.MineboxToast;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8113;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class Utils {
    public static void showShopToastNotification(String prmShopName, String prmTitle, String prmDescription) {
        String texturePath = Utils.shopNameToTexture(prmShopName);
        if (texturePath == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        client.method_1566().method_1999((class_368)new MineboxToast(client.field_1772, class_2960.method_60655((String)"mineboxadditions", (String)texturePath), class_2561.method_30163((String)prmTitle), class_2561.method_30163((String)prmDescription)));
    }

    public static void showToastNotification(String prmTitle, String prmDescription) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        client.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43470((String)prmTitle), (class_2561)class_2561.method_43470((String)prmDescription)));
    }

    public static void playSound(class_3414 prmSound) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        client.field_1724.method_5783(prmSound, 1.0f, 1.0f);
    }

    public static boolean itemHaveStats(class_1799 itemStack) {
        class_9290 loresList = (class_9290)itemStack.method_58694(class_9334.field_49632);
        if (loresList == null) {
            return false;
        }
        for (class_2561 lore : loresList.comp_2400()) {
            for (class_2561 sibling : lore.method_10855()) {
                List nestedSiblings = sibling.method_10855();
                for (class_2561 nestedSibling : nestedSiblings) {
                    class_2588 translatableContent;
                    String translationKey;
                    class_7417 class_74172 = nestedSibling.method_10851();
                    if (!(class_74172 instanceof class_2588) || !(translationKey = (translatableContent = (class_2588)class_74172).method_11022()).contains("mbx.stats.")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isMineboxItem(class_1799 itemStack) {
        class_9279 itemData = (class_9279)itemStack.method_58694(class_9334.field_49628);
        if (itemData == null) {
            return false;
        }
        class_2487 nbtData = itemData.method_57461();
        return nbtData != null && nbtData.method_10545("mbitems:id");
    }

    public static String getMineboxItemId(class_1799 itemStack) {
        if (!Utils.isMineboxItem(itemStack)) {
            return null;
        }
        class_9279 itemData = (class_9279)itemStack.method_58694(class_9334.field_49628);
        if (itemData == null) {
            return null;
        }
        class_2487 nbtData = itemData.method_57461();
        if (nbtData == null || !nbtData.method_10545("mbitems:id")) {
            return null;
        }
        return nbtData.method_10558("mbitems:id").orElse(null);
    }

    public static boolean isItemLooted(class_1799 itemStack) {
        if (!Utils.isMineboxItem(itemStack)) {
            return false;
        }
        class_9279 itemData = (class_9279)itemStack.method_58694(class_9334.field_49628);
        if (itemData == null) {
            return false;
        }
        class_2487 nbtData = itemData.method_57461();
        if (nbtData == null || !nbtData.method_10545("mbitems:looted")) {
            return false;
        }
        return nbtData.method_10550("mbitems:looted").map(value -> value == 1).orElse(false);
    }

    public static boolean isStatsItem(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_65130() == null) {
            return false;
        }
        class_2561 customName = itemStack.method_65130();
        class_7417 class_74172 = customName.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            return "mbx.your_stats.title".equals(translatable.method_11022());
        }
        return false;
    }

    public static int getItemSize(class_1799 itemStack) {
        if (itemStack == null) {
            return 0;
        }
        if (!Utils.isMineboxItem(itemStack)) {
            return 0;
        }
        class_9290 loresList = (class_9290)itemStack.method_58694(class_9334.field_49632);
        if (loresList == null) {
            return 0;
        }
        for (class_2561 lore : loresList.comp_2400()) {
            Object[] args;
            class_2588 tl;
            class_7417 content = lore.method_10851();
            if (content instanceof class_2588 && "mbx.size".equals((tl = (class_2588)content).method_11022()) && (args = tl.method_11023()).length > 0) {
                return Utils.parseIntArg(args[0]);
            }
            for (class_2561 sibling : lore.method_10855()) {
                Object[] args2;
                class_2588 tl2;
                class_7417 sibContent = sibling.method_10851();
                if (!(sibContent instanceof class_2588) || !"mbx.size".equals((tl2 = (class_2588)sibContent).method_11022()) || (args2 = tl2.method_11023()).length <= 0) continue;
                return Utils.parseIntArg(args2[0]);
            }
        }
        return 0;
    }

    public static String getMineboxItemUid(class_1799 itemStack) {
        if (!Utils.isMineboxItem(itemStack)) {
            return null;
        }
        class_9279 itemData = (class_9279)itemStack.method_58694(class_9334.field_49628);
        if (itemData == null) {
            return null;
        }
        class_2487 nbtData = itemData.method_57461();
        if (nbtData == null) {
            return null;
        }
        class_2487 persistentData = nbtData.method_10562("mbitems:persistent").orElse(null);
        if (persistentData == null || !persistentData.method_10545("mbitems:uid")) {
            return null;
        }
        return persistentData.method_10558("mbitems:uid").orElse(null);
    }

    public static MineboxItem findItemByName(List<MineboxItem> items, String itemName) {
        for (MineboxItem item : items) {
            if (!itemName.equals(item.getId())) continue;
            return item;
        }
        return null;
    }

    public static void shinyFoundAlert(String prmPlayerName, String prmMobName) {
        class_310 client = class_310.method_1551();
        class_5250 baseMessage = class_2561.method_43470((String)"The player ").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(false)));
        class_5250 playerText = class_2561.method_43470((String)prmPlayerName).method_10862(class_2583.field_24360.method_10977(class_124.field_1065).method_10982(Boolean.valueOf(true)));
        class_5250 baseMessageNext = class_2561.method_43470((String)" found a shiny ").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(false)));
        class_5250 mobText = class_2561.method_43470((String)("[" + prmMobName + "]")).method_10862(class_2583.field_24360.method_36139(0xFEFE00).method_10982(Boolean.valueOf(true)));
        class_5250 endMessage = class_2561.method_43470((String)" ! Click on this message to send a teleport request.").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(false)).method_10958((class_2558)new class_2558.class_10609("/tpa " + prmPlayerName)));
        class_5250 message = baseMessage.method_27661().method_10852((class_2561)playerText).method_10852((class_2561)baseMessageNext).method_10852((class_2561)mobText).method_10852((class_2561)endMessage);
        client.field_1724.method_7353((class_2561)message, false);
        Utils.playSound(class_3417.field_14709);
    }

    public static String shopNameToTexture(String prmShopName) {
        String sanitizedName = prmShopName.toLowerCase().trim();
        Object returnVal = "textures/toasts/shops/";
        switch (sanitizedName) {
            case "bakery": {
                returnVal = (String)returnVal + "bakery.png";
                break;
            }
            case "mouse": {
                returnVal = (String)returnVal + "mouse.png";
                break;
            }
            case "cocktail": {
                returnVal = (String)returnVal + "cocktail.png";
                break;
            }
            case "buckstar": {
                returnVal = (String)returnVal + "buckstar.png";
                break;
            }
            default: {
                returnVal = null;
            }
        }
        return returnVal;
    }

    public static void displayChatErrorMessage(String prmMessage) {
        class_5250 message = class_2561.method_43470((String)("\u274c " + prmMessage)).method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10982(Boolean.valueOf(false)));
        class_310.method_1551().field_1724.method_7353((class_2561)message, false);
    }

    public static void displayChatSuccessMessage(String prmMessage) {
        class_5250 message = class_2561.method_43470((String)("\u2714 " + prmMessage)).method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10982(Boolean.valueOf(false)));
        class_310.method_1551().field_1724.method_7353((class_2561)message, false);
    }

    public static void displayChatInfoMessage(String prmMessage) {
        class_5250 message = class_2561.method_43470((String)("\ud83d\udec8 " + prmMessage)).method_10862(class_2583.field_24360.method_10977(class_124.field_1078).method_10982(Boolean.valueOf(false)));
        class_310.method_1551().field_1724.method_7353((class_2561)message, false);
    }

    public boolean isHarvestableTextDisplay(class_8113.class_8123 entity) {
        class_2561 text = entity.method_48915();
        class_7417 class_74172 = text.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            String key = translatable.method_11022();
            return key.contains("mbx.harvestable");
        }
        return false;
    }

    public static String formatTime(long totalSeconds) {
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public static String getModVersion() {
        ModMetadata modMetadata = FabricLoader.getInstance().getModContainer("mineboxadditions").isPresent() ? ((ModContainer)FabricLoader.getInstance().getModContainer("mineboxadditions").get()).getMetadata() : null;
        return modMetadata != null ? modMetadata.getVersion().getFriendlyString() : "unknown";
    }

    public static boolean isInteger(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static int parseIntArg(Object arg) {
        if (arg == null) {
            return 0;
        }
        if (arg instanceof class_2561) {
            class_2561 t = (class_2561)arg;
            String s = t.getString().trim();
            return Utils.tryParseInt(s);
        }
        if (arg instanceof Number) {
            Number n = (Number)arg;
            return n.intValue();
        }
        return Utils.tryParseInt(arg.toString().trim());
    }

    private static int tryParseInt(String s) {
        try {
            int slash;
            int space = s.indexOf(32);
            if (space > 0) {
                s = s.substring(0, space);
            }
            if ((slash = s.indexOf(47)) > 0) {
                s = s.substring(0, slash);
            }
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

