/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.events;

import io.dampen59.mineboxadditions.state.State;
import io.dampen59.mineboxadditions.utils.ExtraInventoryUtils;
import io.dampen59.mineboxadditions.utils.SocketManager;
import io.dampen59.mineboxadditions.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_7417;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class ContainerOpenEvent {
    private final State modState;
    private final String[] playerMenuTitles = new String[]{"Player menu", "Menu joueur", "Menu gracza"};
    private final String[] mermaidMenuTitles = new String[]{"Mermaid", "Sir\u00e8ne"};
    private final String[] jobsMenuTitles = new String[]{"Jobs", "M\u00e9tiers"};

    public ContainerOpenEvent(State modState) {
        this.modState = modState;
        ScreenEvents.AFTER_INIT.register(this::onContainerOpened);
    }

    private void onContainerOpened(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (!(screen instanceof class_476)) {
            return;
        }
        class_476 containerScreen = (class_476)screen;
        int slotsCount = ((class_1707)containerScreen.method_17577()).field_7761.size();
        class_2561 containerTitle = containerScreen.method_25440();
        String translationKey = this.extractTranslationKey(containerTitle);
        int baseX = 5;
        int baseY = scaledHeight / 100;
        if (translationKey != null) {
            if (slotsCount <= 45) {
                SocketManager.getSocket().emit("C2SShopOfferEvent", new Object[]{translationKey});
            }
        } else {
            String containerTitleString = containerTitle.getString();
            if (Arrays.stream(this.playerMenuTitles).anyMatch(containerTitleString::contains)) {
                for (int i = 0; i < 4; ++i) {
                    class_4185 equipButton;
                    int setId = i;
                    int yOffset = baseY * 30 + 55 * i;
                    int textBoxX = baseX + 16 + 5;
                    int textBoxY = baseY * 30 + 22 + 2 + 55 * i;
                    class_342 setNameTextbox = new class_342(client.field_1772, textBoxX, textBoxY, 96, 22, (class_2561)class_2561.method_43473());
                    int renameButtonX = baseX;
                    int renameButtonY = baseY * 30 + 12 + 55 * i;
                    int equipButtonX = textBoxX;
                    int equipButtonY = baseY * 30 + 55 * i;
                    class_4185[] equipButtonRef = new class_4185[1];
                    class_4185 renameSaveButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udcbe"), buttonWidget -> {
                        String newName = setNameTextbox.method_1882();
                        if (!newName.isEmpty()) {
                            ExtraInventoryUtils.setSetName(setId, newName);
                            equipButtonRef[0].method_25355((class_2561)class_2561.method_43470((String)("Equip [" + ExtraInventoryUtils.getSetName(setId) + "]")));
                        }
                        ExtraInventoryUtils.saveCurrentSetToSlotId((class_2371<class_1735>)((class_1707)containerScreen.method_17577()).field_7761, setId);
                    }).method_46434(renameButtonX, renameButtonY, 16, 24).method_46431();
                    equipButtonRef[0] = equipButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Equip [" + ExtraInventoryUtils.getSetName(setId) + "]")), buttonWidget -> ExtraInventoryUtils.equipSet((class_2371<class_1735>)((class_1707)containerScreen.method_17577()).field_7761, setId)).method_46434(equipButtonX, equipButtonY, 96, 22).method_46431();
                    screen.method_37063((class_364)setNameTextbox);
                    Screens.getButtons((class_437)containerScreen).add(renameSaveButton);
                    Screens.getButtons((class_437)containerScreen).add(equipButton);
                }
            } else if (Arrays.stream(this.mermaidMenuTitles).anyMatch(containerTitleString::contains)) {
                client.execute(() -> {
                    class_1799 mermaidRequest = ((class_1707)containerScreen.method_17577()).method_7629().method_5438(22);
                    if (!Utils.isMineboxItem(mermaidRequest)) {
                        return;
                    }
                    String itemId = Utils.getMineboxItemId(mermaidRequest);
                    int requestedItemQuantity = mermaidRequest.method_7947();
                    class_2561 nameText = mermaidRequest.method_63015();
                    String requestedItemTranslationKey = this.extractTranslationKey(nameText);
                    String targetResourceKey = null;
                    if (requestedItemTranslationKey.startsWith("mbx.items.container.")) {
                        class_2588 targetResource = this.findDeepestTranslatableContent(nameText);
                        targetResourceKey = targetResource.method_11022();
                    }
                    SocketManager.getSocket().emit("C2SMermaidRequest", new Object[]{itemId, requestedItemQuantity, requestedItemTranslationKey, targetResourceKey});
                });
            } else if (Arrays.stream(this.jobsMenuTitles).anyMatch(containerTitleString::contains)) {
                class_1703 handler = containerScreen.method_17577();
                int delayTicks = 10;
                class JobGuiSlotChecker {
                    int ticks = 0;
                    boolean done = false;

                    JobGuiSlotChecker(ContainerOpenEvent this$0) {
                    }
                }
                JobGuiSlotChecker checker = new JobGuiSlotChecker(this);
                int[] targetSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24};
                ArrayList jobLines = new ArrayList();
                ClientTickEvents.END_CLIENT_TICK.register(mc -> {
                    if (checker.done) {
                        return;
                    }
                    ++checker.ticks;
                    if (checker.ticks >= 10) {
                        int maxJobNameLength = 0;
                        for (int slotIndex : targetSlots) {
                            class_1799 stack;
                            if (slotIndex >= handler.field_7761.size() || (stack = ((class_1735)handler.field_7761.get(slotIndex)).method_7677()).method_7960()) continue;
                            String jobName = stack.method_7964().getString();
                            class_9290 loreComponent = (class_9290)stack.method_58694(class_9334.field_49632);
                            if (loreComponent == null) {
                                return;
                            }
                            Integer level = null;
                            Integer xp = null;
                            Integer xpMax = null;
                            for (class_2561 lore : loreComponent.comp_2400()) {
                                String[] parts;
                                String plain = lore.getString().replaceAll("[^\\d/]", "");
                                if ((lore.getString().contains("Level") || lore.getString().contains("Niveau")) && plain.contains("/") && (parts = plain.split("/")).length == 2) {
                                    try {
                                        level = Integer.parseInt(parts[0]);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (!lore.getString().contains("\udbc0\udc50") || !plain.contains("/") || (parts = plain.split("/")).length != 2) continue;
                                try {
                                    xp = Integer.parseInt(parts[0]);
                                    xpMax = Integer.parseInt(parts[1]);
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                            if (level == null || xp == null || xpMax == null) continue;
                            maxJobNameLength = Math.max(maxJobNameLength, jobName.length());
                            jobLines.add(jobName + "|" + level + "|" + xp + "|" + xpMax);
                        }
                        checker.done = true;
                        StringBuilder jobData2Clipboard = new StringBuilder();
                        for (String line : jobLines) {
                            String[] parts = line.split("\\|");
                            String jobName = parts[0];
                            int level = Integer.parseInt(parts[1]);
                            int xp = Integer.parseInt(parts[2]);
                            int xpMax = Integer.parseInt(parts[3]);
                            jobData2Clipboard.append(String.format("%-" + (maxJobNameLength + 2) + "s %3d (%d/%d)%n", jobName + ":", level, xp, xpMax));
                        }
                        String clipboardText = jobData2Clipboard.toString().trim();
                        class_310.method_1551().field_1774.method_1455(clipboardText);
                    }
                });
            }
        }
    }

    private String extractTranslationKey(class_2561 text) {
        class_7417 class_74172 = text.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            return translatable.method_11022();
        }
        for (class_2561 sibling : text.method_10855()) {
            String key = this.extractTranslationKey(sibling);
            if (key == null) continue;
            return key;
        }
        return null;
    }

    private class_2588 findDeepestTranslatableContent(class_2561 text) {
        class_7417 content = text.method_10851();
        if (content instanceof class_2588) {
            class_2588 translatable = (class_2588)content;
            for (Object arg : translatable.method_11023()) {
                class_2561 innerText;
                class_2588 nested;
                if (!(arg instanceof class_2561) || (nested = this.findDeepestTranslatableContent(innerText = (class_2561)arg)) == null) continue;
                return nested;
            }
            return translatable;
        }
        for (class_2561 sibling : text.method_10855()) {
            class_2588 siblingResult = this.findDeepestTranslatableContent(sibling);
            if (siblingResult == null) continue;
            return siblingResult;
        }
        return null;
    }
}

