/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.events;

import io.dampen59.mineboxadditions.MineboxAdditions;
import io.dampen59.mineboxadditions.config.huds.categories.FishingDrops;
import io.dampen59.mineboxadditions.config.items.ItemsConfig;
import io.dampen59.mineboxadditions.features.fishingshoal.FishingShoalDisplay;
import io.dampen59.mineboxadditions.features.harvestable.HarvestableBeam;
import io.dampen59.mineboxadditions.utils.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;
import net.minecraft.class_863;

public class WorldRendererEvent {
    private static int tickCounter = 0;
    private static final int HIGHLIGHT_TICKS = 120;
    private static final float R = 1.0f;
    private static final float G = 1.0f;
    private static final float B = 1.0f;
    private static final float A = 0.85f;
    private static final int MAX_HIGHLIGHTS = 256;
    private static final List<HighlightEntry> ENTRIES = new ArrayList<HighlightEntry>();

    public WorldRendererEvent() {
        WorldRenderEvents.AFTER_ENTITIES.register(WorldRendererEvent::render);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null) {
                return;
            }
            if (++tickCounter < 200) {
                return;
            }
            tickCounter = 0;
            HashSet<String> liveUuids = new HashSet<String>();
            for (class_1297 entity : client.field_1687.method_18112()) {
                liveUuids.add(entity.method_5667().toString());
            }
            MineboxAdditions.INSTANCE.state.cleanStaleEntityTextCache(liveUuids);
        });
        UseBlockCallback.EVENT.register((player, world, hand, hit) -> {
            if (!ItemsConfig.rangeDisplay) {
                return class_1269.field_5811;
            }
            if (!world.field_9236) {
                return class_1269.field_5811;
            }
            if (!(player instanceof class_746)) {
                return class_1269.field_5811;
            }
            if (hand != class_1268.field_5808) {
                return class_1269.field_5811;
            }
            int itemSize = Utils.getItemSize(player.method_5998(class_1268.field_5808));
            if (itemSize == 0) {
                return class_1269.field_5811;
            }
            class_2350 facing = player.method_5735();
            class_2338 clicked = hit.method_17777();
            class_2338 target = clicked.method_10079(facing, itemSize);
            long now = world.method_8510();
            if (ENTRIES.size() >= 256) {
                ENTRIES.removeFirst();
            }
            ENTRIES.add(new HighlightEntry(target, now + 120L));
            return class_1269.field_5811;
        });
        WorldRenderEvents.LAST.register(context -> {
            class_310 mc = class_310.method_1551();
            if (mc.field_1687 == null || ENTRIES.isEmpty()) {
                return;
            }
            long now = mc.field_1687.method_8510();
            class_243 camPos = context.camera().method_19326();
            class_4587 matrices = context.matrixStack();
            class_4588 buffer = context.consumers().getBuffer(class_1921.method_23594());
            Iterator<HighlightEntry> it = ENTRIES.iterator();
            while (it.hasNext()) {
                class_265 shape;
                HighlightEntry e = it.next();
                if (now > e.untilTick) {
                    it.remove();
                    continue;
                }
                class_2680 state = mc.field_1687.method_8320(e.pos);
                if (state.method_26215() || (shape = state.method_26218((class_1922)mc.field_1687, e.pos)).method_1110()) continue;
                double ox = (double)e.pos.method_10263() - camPos.field_1352;
                double oy = (double)e.pos.method_10264() - camPos.field_1351;
                double oz = (double)e.pos.method_10260() - camPos.field_1350;
                class_863.method_62350((class_4587)matrices, (class_4588)buffer, (class_265)shape, (double)ox, (double)oy, (double)oz, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f, (boolean)true);
            }
        });
    }

    public static void render(WorldRenderContext context) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        if (!Utils.isOnMinebox()) {
            return;
        }
        if (FishingDrops.enabled) {
            FishingShoalDisplay.handle(context);
        }
        HarvestableBeam.render(context);
    }

    private static class HighlightEntry {
        final class_2338 pos;
        final long untilTick;

        HighlightEntry(class_2338 pos, long untilTick) {
            this.pos = pos.method_10062();
            this.untilTick = untilTick;
        }
    }
}

