/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.features.fishingshoal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dampen59.mineboxadditions.MineboxAdditions;
import io.dampen59.mineboxadditions.config.huds.categories.FishingDrops;
import io.dampen59.mineboxadditions.features.fishingshoal.FishingShoal;
import io.dampen59.mineboxadditions.state.State;
import io.dampen59.mineboxadditions.utils.ImageUtils;
import io.dampen59.mineboxadditions.utils.SocketManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1060;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7417;
import net.minecraft.class_8113;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class FishingShoalDisplay {
    private static List<FishingShoal.Item> shoalItems = new ArrayList<FishingShoal.Item>();

    public static void init() {
        SocketManager.getSocket().on("S2CMineboxFishables", FishingShoalDisplay::update);
    }

    private static void update(Object[] args) {
        String jsonData = (String)args[0];
        try {
            ObjectMapper mapper = new ObjectMapper();
            List items = (List)mapper.readValue(jsonData, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, FishingShoal.Item.class));
            for (FishingShoal.Item item : items) {
                if (item.getTexture() == null) {
                    MineboxAdditions.LOGGER.warn("Fish {} has null texture data", (Object)item.getName());
                    continue;
                }
                String textureName = "textures/fish/" + item.getName() + ".png";
                class_2960 resource = ImageUtils.createTextureFromBase64(item.getTexture(), textureName);
                if (resource == null) continue;
                item.setResource(resource);
            }
            shoalItems = items;
        }
        catch (JsonProcessingException e) {
            MineboxAdditions.LOGGER.error("[SocketManager] Failed to load Minebox Fishables JSON: {}", (Object)(e.getMessage() + "\n" + Arrays.toString(e.getStackTrace())));
        }
    }

    public static void handle(WorldRenderContext context) {
        class_310 client = class_310.method_1551();
        class_238 box = client.field_1724.method_5829().method_1014((double)FishingDrops.renderRadius);
        HashMap<class_1297, String> shoals = new HashMap<class_1297, String>();
        for (class_1297 entity2 : client.field_1687.method_8333((class_1297)client.field_1724, box, e -> e instanceof class_8113.class_8123)) {
            String key2 = FishingShoalDisplay.getCachedEntityTextKey(entity2);
            if (key2 == null || !key2.startsWith("mbx.harvestables.shoal")) continue;
            shoals.put(entity2, key2);
        }
        if (!shoals.isEmpty()) {
            shoals.forEach((entity, key) -> FishingShoalDisplay.render(entity, key, context));
        }
    }

    private static void render(class_1297 entity, String translationKey, WorldRenderContext context) {
        if (!FishingShoalDisplay.isBillboardEntity(entity)) {
            return;
        }
        if (!translationKey.contains("shoal")) {
            return;
        }
        String shoalName = translationKey.split("harvestables\\.")[1].split("\\.name")[0];
        class_4587 matrices = context.matrixStack();
        class_4597 vertexConsumers = context.consumers();
        if (matrices == null || vertexConsumers == null) {
            return;
        }
        matrices.method_22903();
        class_243 entityPos = entity.method_19538().method_1020(context.camera().method_19326());
        matrices.method_22904(entityPos.field_1352, entityPos.field_1351 - 0.5, entityPos.field_1350);
        List<class_2960> textures = FishingShoalDisplay.getTexture(shoalName, (class_1937)context.world());
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        float yaw = camera.method_19330();
        float pitch = camera.method_19329();
        float textureSize = 0.5f;
        float spacing = 0.2f;
        int count = textures.size();
        float totalWidth = textureSize * (float)count + spacing * (float)(count - 1);
        float startOffset = -totalWidth / 2.0f + textureSize / 2.0f;
        for (int i = 0; i < textures.size(); ++i) {
            class_2960 texture = textures.get(i);
            class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)texture));
            matrices.method_22903();
            float xOffset = startOffset + (float)i * (textureSize + spacing);
            matrices.method_22907((Quaternionfc)new Quaternionf().rotationYXZ((float)Math.toRadians(-yaw), (float)Math.toRadians(pitch), 0.0f));
            matrices.method_46416(xOffset, 0.0f, 0.0f);
            Matrix4f matrix = matrices.method_23760().method_23761();
            float half = textureSize / 2.0f;
            buffer.method_22918(matrix, -half, -half, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22914(0.0f, 0.0f, 1.0f);
            buffer.method_22918(matrix, -half, half, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22914(0.0f, 0.0f, 1.0f);
            buffer.method_22918(matrix, half, half, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22914(0.0f, 0.0f, 1.0f);
            buffer.method_22918(matrix, half, -half, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22914(0.0f, 0.0f, 1.0f);
            matrices.method_22909();
        }
        matrices.method_22909();
    }

    private static boolean isBillboardEntity(class_1297 entity) {
        if (entity instanceof class_1531) {
            boolean hasEquipment;
            class_1531 stand = (class_1531)entity;
            boolean bl = hasEquipment = !stand.method_6118(class_1304.field_6169).method_7960() || !stand.method_6118(class_1304.field_6174).method_7960() || !stand.method_6118(class_1304.field_6172).method_7960() || !stand.method_6118(class_1304.field_6166).method_7960();
            if (!hasEquipment && (stand.method_5740() || stand.method_5767())) {
                return true;
            }
        }
        if (entity instanceof class_8113.class_8123) {
            return true;
        }
        boolean isStationary = entity.method_5740() || entity.method_18798().method_1027() < 1.0E-4;
        boolean hasText = FishingShoalDisplay.getEntityText(entity) != null;
        boolean isSpecial = entity.method_5864() == class_1299.field_42623 || entity.method_5864() == class_1299.field_6083 || entity.method_5864() == class_1299.field_33456;
        return isStationary && hasText || isSpecial;
    }

    private static class_2561 getEntityText(class_1297 entity) {
        class_8113.class_8123 textDisplay;
        class_2561 t;
        if (entity.method_16914()) {
            return entity.method_5797();
        }
        if (entity instanceof class_8113.class_8123 && (t = (textDisplay = (class_8113.class_8123)entity).method_48915()) != null && !t.getString().isEmpty()) {
            return t;
        }
        return null;
    }

    private static List<class_2960> getTexture(String shoal, class_1937 world) {
        State state = MineboxAdditions.INSTANCE.state;
        ArrayList<class_2960> textures = new ArrayList<class_2960>();
        boolean isRaining = world.method_8419();
        boolean isStorming = world.method_8546();
        boolean isFullMoon = state.getCurrentMoonPhase() == 0;
        long currentWorldTicks = world.method_8532() % 24000L;
        for (FishingShoal.Item item : shoalItems) {
            class_2960 resourceID;
            class_1060 textureManager;
            boolean weatherMet;
            if (!item.getShoal().equals(shoal) || !FishingShoalDisplay.isTimeInRange(item, currentWorldTicks)) continue;
            FishingShoal.Conditions conditions = item.getConditions();
            boolean weatherRequired = Boolean.TRUE.equals(conditions.getRain()) || Boolean.TRUE.equals(conditions.getStorm()) || Boolean.TRUE.equals(conditions.getFullMoon());
            boolean bl = weatherMet = !(Boolean.TRUE.equals(conditions.getRain()) && !isRaining || Boolean.TRUE.equals(conditions.getStorm()) && !isStorming || Boolean.TRUE.equals(conditions.getFullMoon()) && !isFullMoon);
            if (weatherRequired && !weatherMet || !ImageUtils.textureExists(textureManager = class_310.method_1551().method_1531(), resourceID = item.getResource())) continue;
            textures.add(resourceID);
        }
        return textures;
    }

    private static boolean isTimeInRange(FishingShoal.Item item, long currentWorldTicks) {
        int maxTime;
        int minTime = item.getTimeRange().get(0);
        return minTime <= (maxTime = item.getTimeRange().get(1).intValue()) ? currentWorldTicks >= (long)minTime && currentWorldTicks <= (long)maxTime : currentWorldTicks >= (long)minTime || currentWorldTicks <= (long)maxTime;
    }

    private static String getCachedEntityTextKey(class_1297 entity) {
        State state = MineboxAdditions.INSTANCE.state;
        String uuid = entity.method_5667().toString();
        if (state.hasEntityTextCached(uuid)) {
            return state.getCachedEntityText(uuid);
        }
        String result = FishingShoalDisplay.getEntityTextKeyUncached(entity);
        state.cacheEntityText(uuid, result);
        return result;
    }

    private static String getEntityTextKeyUncached(class_1297 entity) {
        class_2561 t;
        class_2561 class_25612 = t = entity.method_16914() ? entity.method_5797() : null;
        if (t == null && entity instanceof class_8113.class_8123) {
            class_8113.class_8123 td = (class_8113.class_8123)entity;
            t = td.method_48915();
        }
        if (t == null) {
            return null;
        }
        return FishingShoalDisplay.extractShoalTranslationKey(t);
    }

    private static String extractShoalTranslationKey(class_2561 text) {
        if (text == null) {
            return null;
        }
        class_7417 class_74172 = text.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 tc = (class_2588)class_74172;
            String key = tc.method_11022();
            if (key != null && key.startsWith("mbx.harvestables.shoal")) {
                return key;
            }
            for (Object arg : tc.method_11023()) {
                class_2561 tArg;
                String found;
                if (!(arg instanceof class_2561) || (found = FishingShoalDisplay.extractShoalTranslationKey(tArg = (class_2561)arg)) == null) continue;
                return found;
            }
        }
        for (class_2561 sibling : text.method_10855()) {
            String found = FishingShoalDisplay.extractShoalTranslationKey(sibling);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

