/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.features.hud;

import io.dampen59.mineboxadditions.config.ConfigManager;
import io.dampen59.mineboxadditions.config.huds.objects.ItemPickupHud;
import io.dampen59.mineboxadditions.features.hud.Hud;
import io.dampen59.mineboxadditions.features.hud.HudManager;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class HudEditorScreen
extends class_437 {
    private DragContext dragContext = null;
    private boolean dirty = false;
    private static final int PADDING = 2;
    private static final int MARGIN = 4;

    public HudEditorScreen() {
        super(class_2561.method_30163((String)"HUD Editor"));
    }

    private boolean isInBounds(double mouseX, double mouseY, int x, int y, int w, int h) {
        return mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
    }

    private Point clampToScreen(Hud hud, int x, int y) {
        int clampedX = Math.max(4, Math.min(this.field_22789 - hud.getWidth() - 4, x));
        int clampedY = Math.max(4, Math.min(this.field_22790 - hud.getHeight() - 4, y));
        return new Point(clampedX, clampedY);
    }

    private Point resolveCollisions(Hud hud, int x, int y) {
        boolean collision;
        Bounds hudBounds = new Bounds(x, y, hud.getWidth(), hud.getHeight());
        int iterations = 0;
        do {
            collision = false;
            for (Hud otherHud : HudManager.INSTANCE.getAll()) {
                double overlapY;
                Bounds otherBounds;
                if (otherHud.getClass() == this.dragContext.type || !hudBounds.intersects(otherBounds = new Bounds(otherHud.getX() - 2, otherHud.getY() - 2, otherHud.getWidth() + 4, otherHud.getHeight() + 4))) continue;
                collision = true;
                double overlapX = (double)hudBounds.width / 2.0 + (double)otherBounds.width / 2.0 - Math.abs(hudBounds.centerX() - otherBounds.centerX());
                if (overlapX < (overlapY = (double)hudBounds.height / 2.0 + (double)otherBounds.height / 2.0 - Math.abs(hudBounds.centerY() - otherBounds.centerY()))) {
                    x = (int)((double)x + (hudBounds.centerX() < otherBounds.centerX() ? -overlapX : overlapX));
                } else {
                    y = (int)((double)y + (hudBounds.centerY() < otherBounds.centerY() ? -overlapY : overlapY));
                }
                hudBounds.set(x, y);
            }
        } while (collision && ++iterations < 10);
        return new Point(x, y);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (Hud hud : HudManager.INSTANCE.getAll()) {
            int hudY;
            int hudX = hud.getX();
            if (!this.isInBounds(mouseX, mouseY, hudX, hudY = hud.getY(), hud.getWidth(), hud.getHeight())) continue;
            this.dragContext = new DragContext(hud.getClass(), button, (int)mouseX - hudX, (int)mouseY - hudY);
            if (button == 1) {
                hud.setState(!hud.getState());
                this.dirty = true;
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragContext != null && this.dragContext.button == 0) {
            Hud hud = HudManager.INSTANCE.get(this.dragContext.type);
            Point clamped = this.clampToScreen(hud, (int)mouseX - this.dragContext.offsetX, (int)mouseY - this.dragContext.offsetY);
            Point resolved = this.resolveCollisions(hud, clamped.x, clamped.y);
            if (this.dragContext.type.equals(ItemPickupHud.class) && resolved.x > this.field_22789 / 2) {
                hud.setX(resolved.x + hud.getWidth());
            } else {
                hud.setX(resolved.x);
            }
            hud.setY(resolved.y);
            this.dirty = true;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.dragContext != null) {
            boolean outOfBounds;
            Hud hud = HudManager.INSTANCE.get(this.dragContext.type);
            boolean bl = outOfBounds = hud.getX() < 0 || hud.getX() + hud.getWidth() > this.field_22789 || hud.getY() < 0 || hud.getY() + hud.getHeight() > this.field_22790;
            if (outOfBounds) {
                hud.setX((this.field_22789 - hud.getWidth()) / 2);
                hud.setY((this.field_22790 - hud.getHeight()) / 2);
                this.dirty = true;
            }
        }
        if (this.dirty) {
            ConfigManager.save();
            this.dirty = false;
        }
        this.dragContext = null;
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        for (Hud hud : HudManager.INSTANCE.getAll()) {
            if (hud.getState()) {
                hud.draw(context);
                continue;
            }
            hud.drawDisabled(context);
        }
    }

    public boolean method_25421() {
        return false;
    }

    private static class DragContext {
        final Class<? extends Hud> type;
        final int button;
        final int offsetX;
        final int offsetY;

        DragContext(Class<? extends Hud> type, int button, int offsetX, int offsetY) {
            this.type = type;
            this.button = button;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }
    }

    private static class Point {
        final int x;
        final int y;

        Point(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    private static class Bounds {
        int x;
        int y;
        int width;
        int height;

        Bounds(int x, int y, int width, int height) {
            this.set(x, y, width, height);
        }

        void set(int x, int y) {
            this.x = x;
            this.y = y;
        }

        void set(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        double centerX() {
            return (double)this.x + (double)this.width / 2.0;
        }

        double centerY() {
            return (double)this.y + (double)this.height / 2.0;
        }

        boolean intersects(Bounds other) {
            return this.x < other.x + other.width && this.x + this.width > other.x && this.y < other.y + other.height && this.y + this.height > other.y;
        }
    }
}

