/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.features.hud.huds;

import io.dampen59.mineboxadditions.MineboxAdditions;
import io.dampen59.mineboxadditions.config.huds.HudsConfig;
import io.dampen59.mineboxadditions.config.huds.categories.HudPositions;
import io.dampen59.mineboxadditions.features.hud.Hud;
import io.dampen59.mineboxadditions.features.hud.elements.Element;
import io.dampen59.mineboxadditions.features.hud.elements.SpacerElement;
import io.dampen59.mineboxadditions.features.hud.elements.TextElement;
import io.dampen59.mineboxadditions.features.hud.elements.TextureElement;
import io.dampen59.mineboxadditions.features.hud.elements.stack.HStackElement;
import io.dampen59.mineboxadditions.features.hud.elements.stack.StackElement;
import io.dampen59.mineboxadditions.features.hud.elements.stack.VStackElement;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class WeatherHud {
    private static String formatNextEventCountdown(List<Integer> timestamps) {
        if (timestamps == null || timestamps.isEmpty()) {
            return "Unknown";
        }
        List<Integer> snapshot = WeatherHud.snapshotList(timestamps);
        if (snapshot.isEmpty()) {
            return "Unknown";
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        Integer next = null;
        for (Integer ts : snapshot) {
            if (ts == null || ts <= now || next != null && ts >= next) continue;
            next = ts;
        }
        if (next == null) {
            return "Unknown";
        }
        int secondsLeft = next - now;
        int hours = secondsLeft / 3600;
        int minutes = secondsLeft % 3600 / 60;
        int seconds = secondsLeft % 60;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private static List<Integer> snapshotList(List<Integer> src) {
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                return new ArrayList<Integer>(src);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        ArrayList<Integer> fallback = new ArrayList<Integer>();
        try {
            for (Integer i : src) {
                fallback.add(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fallback;
    }

    public static class StormHud
    extends Hud {
        public StormHud() {
            super(() -> HudsConfig.storm, s -> {
                HudsConfig.storm = s;
            }, () -> HudPositions.storm.x, x -> {
                HudPositions.storm.x = x;
            }, () -> HudPositions.storm.y, y -> {
                HudPositions.storm.y = y;
            });
            ClientTickEvents.END_CLIENT_TICK.register(this::update);
        }

        @Override
        public StackElement init() {
            class_2960 texture = class_2960.method_60655((String)"mineboxadditions", (String)"textures/icons/storm.png");
            TextElement text = new TextElement(class_2561.method_30163((String)"00:00:00"));
            HStackElement hstack = (HStackElement)((HStackElement)((HStackElement)((HStackElement)((HStackElement)new HStackElement().add((Element)new SpacerElement(4))).add((Element)new TextureElement(texture, 10, 10))).add((Element)new SpacerElement(4))).add((Element)new VStackElement().add(new SpacerElement(1), text))).add((Element)new SpacerElement(4));
            this.addNamedElement("text", text);
            return new VStackElement().add(new SpacerElement(2), hstack, new SpacerElement(2));
        }

        private void update(class_310 client) {
            if (client.field_1687 == null) {
                return;
            }
            String text = client.field_1687.method_8546() ? "Now!" : WeatherHud.formatNextEventCountdown(MineboxAdditions.INSTANCE.state.getWeatherState().getStormTimestamps());
            this.getNamedElement("text", TextElement.class).setText(class_2561.method_30163((String)text));
        }
    }

    public static class RainHud
    extends Hud {
        public RainHud() {
            super(() -> HudsConfig.rain, s -> {
                HudsConfig.rain = s;
            }, () -> HudPositions.rain.x, x -> {
                HudPositions.rain.x = x;
            }, () -> HudPositions.rain.y, y -> {
                HudPositions.rain.y = y;
            });
            ClientTickEvents.END_CLIENT_TICK.register(this::update);
        }

        @Override
        public StackElement init() {
            class_2960 texture = class_2960.method_60655((String)"mineboxadditions", (String)"textures/icons/rain.png");
            TextElement text = new TextElement(class_2561.method_30163((String)"00:00:00"));
            HStackElement hstack = (HStackElement)((HStackElement)((HStackElement)((HStackElement)((HStackElement)new HStackElement().add((Element)new SpacerElement(4))).add((Element)new TextureElement(texture, 10, 10))).add((Element)new SpacerElement(4))).add((Element)new VStackElement().add(new SpacerElement(1), text))).add((Element)new SpacerElement(4));
            this.addNamedElement("text", text);
            return new VStackElement().add(new SpacerElement(2), hstack, new SpacerElement(2));
        }

        private void update(class_310 client) {
            if (client.field_1687 == null) {
                return;
            }
            String text = client.field_1687.method_8419() ? "Now!" : WeatherHud.formatNextEventCountdown(MineboxAdditions.INSTANCE.state.getWeatherState().getRainTimestamps());
            this.getNamedElement("text", TextElement.class).setText(class_2561.method_30163((String)text));
        }
    }

    public static class FullMoonHud
    extends Hud {
        public FullMoonHud() {
            super(() -> HudsConfig.fullmoon, s -> {
                HudsConfig.fullmoon = s;
            }, () -> HudPositions.fullMoon.x, x -> {
                HudPositions.fullMoon.x = x;
            }, () -> HudPositions.fullMoon.y, y -> {
                HudPositions.fullMoon.y = y;
            });
        }

        @Override
        public StackElement init() {
            class_2960 texture = class_2960.method_60655((String)"mineboxadditions", (String)"textures/icons/full_moon.png");
            HStackElement hstack = (HStackElement)((HStackElement)((HStackElement)new HStackElement().add((Element)new SpacerElement(2))).add((Element)new TextureElement(texture, 10, 10))).add((Element)new SpacerElement(2));
            return new VStackElement().add(new SpacerElement(2), hstack, new SpacerElement(2));
        }
    }
}

