/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.features.hud.huds.haversack;

import io.dampen59.mineboxadditions.features.hud.HudManager;
import io.dampen59.mineboxadditions.features.hud.huds.haversack.HaversackHud;
import io.dampen59.mineboxadditions.utils.Utils;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.minecraft.class_9779;

public class HaversackManager {
    private int lastAmountInside = -1;
    private double fillRatePerSecond = 0.0;
    private String timeUntilFull = "";
    private long lastCheckTime = System.currentTimeMillis();

    public HaversackManager() {
        ClientTickEvents.END_CLIENT_TICK.register(this::handle);
        HudRenderCallback.EVENT.register(this::render);
    }

    private void handle(class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null || !Utils.isOnMinebox()) {
            return;
        }
        class_1799 offHandStack = client.field_1724.method_6079();
        String offHandStackId = Utils.getMineboxItemId(offHandStack);
        if (offHandStackId != null && offHandStackId.startsWith("haversack_")) {
            this.handleStack(offHandStack);
        } else {
            this.reset();
        }
    }

    private void render(class_332 context, class_9779 tickCounter) {
        if (this.fillRatePerSecond != 0.0) {
            HaversackHud.RateHud rate = HudManager.INSTANCE.get(HaversackHud.RateHud.class);
            rate.update(this.fillRatePerSecond);
            if (rate.getState()) {
                rate.draw(context);
            }
            HaversackHud.FullHud full = HudManager.INSTANCE.get(HaversackHud.FullHud.class);
            full.update(this.timeUntilFull);
            if (full.getState()) {
                full.draw(context);
            }
        }
    }

    private void handleStack(class_1799 stack) {
        class_9279 itemData = (class_9279)stack.method_58694(class_9334.field_49628);
        if (itemData == null) {
            return;
        }
        class_2487 nbtData = itemData.method_57461();
        if (nbtData == null || !nbtData.method_10545("mbitems:id")) {
            return;
        }
        String id = nbtData.method_10558("mbitems:id").orElse("");
        class_9290 loreComponent = (class_9290)stack.method_58694(class_9334.field_49632);
        if (loreComponent == null) {
            return;
        }
        for (class_2561 lore : loreComponent.comp_2400()) {
            class_7417 class_74172 = lore.method_10851();
            if (!(class_74172 instanceof class_2588)) continue;
            class_2588 translatableContent = (class_2588)class_74172;
            if (!id.contains("haversack") || !translatableContent.method_11022().contains("mbx.items.infinite_bag.amount_inside")) continue;
            this.parseInformation(stack, nbtData, translatableContent);
        }
    }

    private void parseInformation(class_1799 stack, class_2487 nbtData, class_2588 content) {
        class_5348 quantityArg = content.method_29434(0);
        String[] parts = quantityArg.getString().split("/");
        if (parts.length < 2) {
            return;
        }
        int maxQuantity = Integer.parseInt(parts[1]);
        class_2487 persistentData = nbtData.method_10562("mbitems:persistent").orElse(null);
        int amountInside = persistentData.method_10550("mbitems:amount_inside").orElse(0);
        long currentTime = System.currentTimeMillis();
        if (this.lastAmountInside >= 0) {
            long deltaTime = currentTime - this.lastCheckTime;
            if (deltaTime >= 1000L) {
                int deltaAmount = amountInside - this.lastAmountInside;
                this.fillRatePerSecond = (double)deltaAmount / ((double)deltaTime / 1000.0);
                this.lastCheckTime = currentTime;
                this.lastAmountInside = amountInside;
                int remaining = maxQuantity - amountInside;
                if (this.fillRatePerSecond > 0.0) {
                    long secondsLeft = (long)((double)remaining / this.fillRatePerSecond);
                    this.timeUntilFull = Utils.formatTime(secondsLeft);
                } else {
                    this.timeUntilFull = "\u221e";
                }
            }
        } else {
            this.lastAmountInside = amountInside;
            this.lastCheckTime = currentTime;
            this.timeUntilFull = "";
        }
    }

    private void reset() {
        this.lastAmountInside = -1;
        this.fillRatePerSecond = 0.0;
        this.timeUntilFull = "";
    }
}

