/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.features.hud.huds.itempickup;

import io.dampen59.mineboxadditions.config.huds.HudsConfig;
import io.dampen59.mineboxadditions.features.hud.HudManager;
import io.dampen59.mineboxadditions.features.hud.elements.ItemStackElement;
import io.dampen59.mineboxadditions.features.hud.elements.TextElement;
import io.dampen59.mineboxadditions.features.hud.huds.itempickup.ItemPickupHud;
import io.dampen59.mineboxadditions.utils.Utils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;

public class ItemPickupManager {
    private final class_310 client = class_310.method_1551();
    private final Map<Integer, Integer> previousInventoryCounts = new HashMap<Integer, Integer>();
    private final Deque<ItemPickupNotification> itemPickupNotifications = new ArrayDeque<ItemPickupNotification>();

    public ItemPickupManager() {
        ClientTickEvents.END_CLIENT_TICK.register(this::onTick);
        HudRenderCallback.EVENT.register(this::onRender);
    }

    private void onTick(class_310 client) {
        io.dampen59.mineboxadditions.config.huds.objects.ItemPickupHud settings = HudsConfig.itempickup;
        if (!settings.enabled) {
            return;
        }
        int displayDuration = settings.duration * 20;
        this.updateInventorySnapshot(displayDuration, settings.count, settings.merge);
        this.tickNotifications();
    }

    private void onRender(class_332 context, class_9779 tickCounter) {
        ItemPickupHud hud = HudManager.INSTANCE.get(ItemPickupHud.class);
        int offsetY = 0;
        for (ItemPickupNotification notif : this.itemPickupNotifications) {
            class_1799 item = notif.stack.method_7972();
            item.method_7939(notif.count);
            hud.getNamedElement("item", ItemStackElement.class).setItem(item);
            hud.getNamedElement("name", TextElement.class).setText(item.method_7964());
            if (hud.getState()) {
                hud.draw(context, offsetY);
            }
            offsetY += hud.getHeight() + 2;
        }
    }

    private void updateInventorySnapshot(int duration, int max, boolean merge) {
        if (this.client.field_1755 != null || this.client.field_1724 == null) {
            return;
        }
        class_2371 currentInv = this.client.field_1724.method_31548().method_67533();
        for (int slot = 0; slot < currentInv.size(); ++slot) {
            class_1799 currentStack = (class_1799)currentInv.get(slot);
            int currentCount = currentStack.method_7947();
            int previousCount = this.previousInventoryCounts.getOrDefault(slot, 0);
            if (currentStack.method_7960() || currentCount <= previousCount) continue;
            int gained = currentCount - previousCount;
            this.addOrUpdateNotification(currentStack.method_7972(), gained, duration, max, merge);
        }
        this.previousInventoryCounts.clear();
        for (int i = 0; i < currentInv.size(); ++i) {
            this.previousInventoryCounts.put(i, ((class_1799)currentInv.get(i)).method_7947());
        }
    }

    private void tickNotifications() {
        this.itemPickupNotifications.removeIf(notif -> --notif.displayTicks <= 0);
    }

    private void addOrUpdateNotification(class_1799 stack, int count, int duration, int max, boolean merge) {
        if (Utils.isInventoryBaseItem(stack)) {
            return;
        }
        if (merge) {
            for (ItemPickupNotification notif : this.itemPickupNotifications) {
                if (!class_1799.method_31577((class_1799)notif.stack, (class_1799)stack)) continue;
                notif.add(count, duration);
                return;
            }
        }
        this.itemPickupNotifications.add(new ItemPickupNotification(stack, count, duration));
        if (this.itemPickupNotifications.size() > max) {
            this.itemPickupNotifications.removeFirst();
        }
    }

    private static class ItemPickupNotification {
        final class_1799 stack;
        int count;
        int displayTicks;

        ItemPickupNotification(class_1799 stack, int count, int displayTicks) {
            this.stack = stack;
            this.count = count;
            this.displayTicks = displayTicks;
        }

        void add(int more, int resetDuration) {
            this.count += more;
            this.displayTicks = resetDuration;
        }
    }
}

