/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.features.item;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3532;
import net.minecraft.class_7417;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Unique;

public class ItemDurability {
    public static Optional<Durability> getDurability(class_1799 item) {
        String[] parts = ItemDurability.getDurabilityParts(item);
        if (parts.length != 2) {
            return Optional.empty();
        }
        try {
            int current = Integer.parseInt(parts[0]);
            int max = Integer.parseInt(parts[1]);
            int damage = max - current;
            return Optional.of(new Durability(current, max, damage));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static boolean hasDurability(class_1799 item) {
        String[] parts = ItemDurability.getDurabilityParts(item);
        return parts.length == 2 && !parts[0].equals(parts[1]);
    }

    public static Integer getDurabilityStep(class_1799 item) {
        return ItemDurability.getDurability(item).map(d -> class_3532.method_15340((int)Math.round(13.0f - (float)d.damage() * 13.0f / (float)d.max()), (int)0, (int)13)).orElse(-1);
    }

    public static Integer getDurabilityColor(class_1799 item) {
        return ItemDurability.getDurability(item).map(d -> {
            float f = Math.max(0.0f, ((float)d.max() - (float)d.damage()) / (float)d.max());
            return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
        }).orElse(-1);
    }

    @Unique
    private static String[] getDurabilityParts(class_1799 item) {
        class_9279 customData = (class_9279)item.method_58694(class_9334.field_49628);
        if (customData == null) {
            return new String[0];
        }
        class_2487 nbt = customData.method_57461();
        if (!nbt.method_10545("mbitems:id")) {
            return new String[0];
        }
        String id = nbt.method_10558("mbitems:id").orElse(null);
        if (id == null) {
            return new String[0];
        }
        class_9290 lore = (class_9290)item.method_58694(class_9334.field_49632);
        if (lore == null) {
            return new String[0];
        }
        for (class_2561 line : lore.comp_2400()) {
            class_2588 content;
            class_7417 class_74172 = line.method_10851();
            if (!(class_74172 instanceof class_2588) || !(content = (class_2588)class_74172).method_11022().contains("mbx.durability") && !content.method_11022().contains("mbx.items.infinite_bag.amount_inside")) continue;
            return content.method_29434(0).getString().split("/");
        }
        return new String[0];
    }

    public record Durability(int current, int max, int damage) {
    }
}

