/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.features.voicechat;

import io.dampen59.mineboxadditions.MineboxAdditions;
import io.dampen59.mineboxadditions.config.Config;
import io.dampen59.mineboxadditions.config.ConfigManager;
import io.dampen59.mineboxadditions.features.voicechat.AudioDeviceState;
import io.dampen59.mineboxadditions.features.voicechat.AudioManager;
import io.dampen59.mineboxadditions.features.voicechat.widgets.MicGainSlider;
import io.dampen59.mineboxadditions.features.voicechat.widgets.VolumeMultiplierSlider;
import io.dampen59.mineboxadditions.utils.AudioUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5676;

public class AudioDeviceScreen
extends class_437 {
    private static final int WIDGET_WIDTH = 256;
    private static final float SMOOTHING_SPEED = 0.2f;
    private TargetDataLine micTestLine;
    private Thread micThread;
    private boolean micRunning = false;
    private volatile float currentMicLevel = 0.0f;
    private volatile float currentMicDbFS = -100.0f;
    private float smoothedMicLevel = 0.0f;
    private int micBarY = 0;

    public AudioDeviceScreen() {
        super((class_2561)class_2561.method_43470((String)"Select Audio Devices"));
    }

    public void method_25393() {
        super.method_25393();
        this.smoothedMicLevel += (this.currentMicLevel - this.smoothedMicLevel) * 0.2f;
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int currentY = 30;
        this.drawGroupTitle("\ud83c\udfa4 Input Device", centerX, currentY);
        currentY += 25;
        currentY = this.addDeviceSelector(centerX, currentY, AudioUtils.getInputMixers(), true);
        this.method_37063((class_364)new MicGainSlider(centerX - 128, currentY, 256, 20, AudioDeviceState.micGainDb));
        this.micBarY = currentY += 30;
        this.drawGroupTitle("\ud83d\udd0a Output Device", centerX, currentY += 40);
        currentY += 25;
        currentY = this.addDeviceSelector(centerX, currentY, AudioUtils.getOutputMixers(), false);
        this.method_37063((class_364)new VolumeMultiplierSlider(centerX - 128, currentY, 256, 20, AudioDeviceState.speakerVolumeMultiplier));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Test Speaker"), b -> this.playTestTone()).method_46433(centerX - 128, currentY += 25).method_46437(256, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), b -> {
            this.stopMicThread();
            class_310.method_1551().method_1507(null);
        }).method_46433(centerX - 128, (currentY += 25) + 20).method_46437(256, 20).method_46431());
        this.restartMicTestLine();
    }

    private void drawGroupTitle(String label, int centerX, int y) {
        ((class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)label), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$drawGroupTitle$2(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)()).method_46433((int)(centerX - 128), (int)y).method_46437((int)256, (int)20).method_46431())).field_22763 = false;
    }

    private int addDeviceSelector(int centerX, int y, Mixer.Info[] devices, boolean isInput) {
        Mixer.Info selected;
        List<Mixer.Info> list = Arrays.asList(devices);
        if (list.isEmpty()) {
            ((class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"No devices found"), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$addDeviceSelector$3(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)()).method_46433((int)(centerX - 128), (int)y).method_46437((int)256, (int)20).method_46431())).field_22763 = false;
            return y + 25;
        }
        Mixer.Info info2 = selected = isInput ? AudioDeviceState.selectedInput : AudioDeviceState.selectedOutput;
        if (selected == null) {
            selected = list.get(0);
            if (isInput) {
                AudioDeviceState.selectedInput = selected;
            } else {
                AudioDeviceState.selectedOutput = selected;
            }
        }
        this.method_37063((class_364)class_5676.method_32606(info -> class_2561.method_43470((String)info.getName())).method_32620(list).method_32619((Object)selected).method_32617(centerX - 128, y, 256, 20, (class_2561)class_2561.method_43470((String)"Device"), (button, value) -> {
            AudioManager audioManager = MineboxAdditions.INSTANCE.state.getAudioManager();
            if (isInput) {
                AudioDeviceState.selectedInput = value;
                if (audioManager != null) {
                    try {
                        audioManager.openMicrophone();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                Config.selectedMicName = value.getName();
                ConfigManager.save();
                this.restartMicTestLine();
            } else {
                AudioDeviceState.selectedOutput = value;
                if (audioManager != null) {
                    try {
                        audioManager.openSpeaker();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                Config.selectedSpeakerName = value.getName();
                ConfigManager.save();
            }
        }));
        return y + 25;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int barX = this.field_22789 / 2 - 128;
        int barY = this.micBarY;
        int barHeight = 10;
        context.method_25294(barX, barY, barX + 256, barY + barHeight, -13421773);
        float estimatedSPL = this.currentMicDbFS + 96.0f;
        float normalized = Math.min(Math.max((estimatedSPL - 50.0f) / 46.0f, 0.0f), 1.0f);
        int fillWidth = (int)(normalized * 256.0f);
        int fillColor = -16711936;
        if (estimatedSPL >= 85.0f) {
            fillColor = -65536;
        } else if (estimatedSPL >= 75.0f) {
            fillColor = -23296;
        } else if (estimatedSPL >= 65.0f) {
            fillColor = -5374161;
        }
        context.method_25294(barX, barY, barX + fillWidth, barY + barHeight, fillColor);
    }

    private void restartMicTestLine() {
        this.stopMicThread();
        this.startMicLevelThread();
    }

    private void stopMicThread() {
        AudioManager audioManager;
        TargetDataLine sharedMic;
        if (this.micThread != null && this.micThread.isAlive()) {
            this.micThread.interrupt();
            this.micThread = null;
        }
        TargetDataLine targetDataLine = sharedMic = (audioManager = MineboxAdditions.INSTANCE.state.getAudioManager()) != null ? audioManager.getMicrophone() : null;
        if (this.micTestLine != null && this.micTestLine.isOpen()) {
            if (this.micTestLine != sharedMic) {
                this.micTestLine.stop();
                this.micTestLine.close();
            }
            this.micTestLine = null;
        }
        this.micRunning = false;
        this.currentMicLevel = 0.0f;
        this.smoothedMicLevel = 0.0f;
    }

    private void startMicLevelThread() {
        if (this.micRunning || AudioDeviceState.selectedInput == null) {
            return;
        }
        this.micRunning = true;
        this.micThread = new Thread(() -> {
            try {
                TargetDataLine sharedMic;
                AudioFormat format = new AudioFormat(48000.0f, 16, 1, true, false);
                DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
                Mixer mixer = AudioSystem.getMixer(AudioDeviceState.selectedInput);
                AudioManager audioManager = MineboxAdditions.INSTANCE.state.getAudioManager();
                TargetDataLine targetDataLine = sharedMic = audioManager != null ? audioManager.getMicrophone() : null;
                if (sharedMic != null && sharedMic.isOpen()) {
                    this.micTestLine = sharedMic;
                } else {
                    this.micTestLine = (TargetDataLine)mixer.getLine(info);
                    this.micTestLine.open(format);
                    this.micTestLine.start();
                }
                byte[] buffer = new byte[480];
                while (!Thread.currentThread().isInterrupted() && this.micTestLine.isOpen() && class_310.method_1551().field_1755 == this) {
                    int available = this.micTestLine.available();
                    if (available < buffer.length) {
                        Thread.yield();
                        continue;
                    }
                    int bytesRead = this.micTestLine.read(buffer, 0, buffer.length);
                    if (bytesRead <= 0) continue;
                    float linearGain = (float)Math.pow(10.0, (double)AudioDeviceState.micGainDb / 20.0);
                    double sum = 0.0;
                    int samples = 0;
                    for (int i = 0; i < bytesRead - 1; i += 2) {
                        short sample = (short)(buffer[i + 1] << 8 | buffer[i] & 0xFF);
                        float amplified = (float)sample * linearGain;
                        sum += (double)(amplified * amplified);
                        ++samples;
                    }
                    if (samples > 0) {
                        float rms = (float)Math.sqrt(sum / (double)samples);
                        this.currentMicLevel = Math.min(1.0f, rms / 32768.0f);
                    }
                    this.currentMicDbFS = this.currentMicLevel <= 1.0E-5f ? -100.0f : 20.0f * (float)Math.log10(Math.max(this.smoothedMicLevel, 1.0E-4f));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.micRunning = false;
            }
        });
        this.micThread.start();
    }

    private void playTestTone() {
        new Thread(() -> {
            try {
                AudioFormat format = new AudioFormat(48000.0f, 16, 2, true, false);
                Mixer mixer = AudioSystem.getMixer(AudioDeviceState.selectedOutput);
                if (mixer == null) {
                    System.err.println("No valid speaker selected");
                    return;
                }
                SourceDataLine line = (SourceDataLine)mixer.getLine(new DataLine.Info(SourceDataLine.class, format));
                line.open(format);
                line.start();
                int durationMs = 500;
                double freq = 440.0;
                byte[] buffer = new byte[(int)((float)format.getFrameSize() * format.getFrameRate() * (float)durationMs / 1000.0f)];
                float gain = AudioDeviceState.speakerVolumeMultiplier;
                for (int i = 0; i < buffer.length / 4; ++i) {
                    double angle = Math.PI * 2 * (double)i * freq / (double)format.getSampleRate();
                    float raw = (float)(Math.sin(angle) * 32767.0 * (double)gain);
                    raw = Math.max(-32768.0f, Math.min(32767.0f, raw));
                    short sample = (short)raw;
                    buffer[4 * i] = (byte)(sample & 0xFF);
                    buffer[4 * i + 1] = (byte)(sample >> 8 & 0xFF);
                    buffer[4 * i + 2] = (byte)(sample & 0xFF);
                    buffer[4 * i + 3] = (byte)(sample >> 8 & 0xFF);
                }
                line.write(buffer, 0, buffer.length);
                line.drain();
                line.stop();
                line.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        AudioManager audioManager;
        TargetDataLine sharedMic;
        if (this.micThread != null && this.micThread.isAlive()) {
            this.micThread.interrupt();
            this.micThread = null;
        }
        TargetDataLine targetDataLine = sharedMic = (audioManager = MineboxAdditions.INSTANCE.state.getAudioManager()) != null ? audioManager.getMicrophone() : null;
        if (this.micTestLine != null && this.micTestLine.isOpen()) {
            if (this.micTestLine != sharedMic) {
                this.micTestLine.stop();
                this.micTestLine.close();
            }
            this.micTestLine = null;
        }
        this.micRunning = false;
        this.currentMicLevel = 0.0f;
        this.smoothedMicLevel = 0.0f;
        super.method_25419();
    }

    private static /* synthetic */ void lambda$addDeviceSelector$3(class_4185 b) {
    }

    private static /* synthetic */ void lambda$drawGroupTitle$2(class_4185 b) {
    }
}

