/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.mixins;

import io.dampen59.mineboxadditions.MineboxAdditions;
import io.dampen59.mineboxadditions.utils.SocketManager;
import io.dampen59.mineboxadditions.utils.Utils;
import io.dampen59.mineboxadditions.utils.WeatherUtils;
import net.minecraft.class_2561;
import net.minecraft.class_634;
import net.minecraft.class_7439;
import org.json.JSONException;
import org.json.JSONObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_634.class})
public class ChatMessageMixin {
    @Inject(method={"onGameMessage"}, at={@At(value="HEAD")})
    private void mbx$onGameMessage(class_7439 packet, CallbackInfo ci) throws JSONException {
        class_2561 messageText = packet.comp_763();
        String rawMessage = messageText.getString();
        if (!WeatherUtils.isFullWeatherMessage(rawMessage)) {
            return;
        }
        String lastCommand = MineboxAdditions.INSTANCE.state.getLastSentCommand();
        if (lastCommand == null) {
            return;
        }
        if (lastCommand.startsWith("/prediction") || lastCommand.startsWith("/meteo") || lastCommand.startsWith("/forecast") || lastCommand.startsWith("/weather")) {
            WeatherUtils.ForecastResult forecastData;
            int dayIndex = 0;
            String[] weatherArgs = lastCommand.split(" ");
            if (weatherArgs.length > 1) {
                if (!Utils.isInteger(weatherArgs[1])) {
                    return;
                }
                dayIndex = Integer.parseInt(weatherArgs[1]);
                if (dayIndex < 0 || dayIndex > 7) {
                    return;
                }
            }
            if ((forecastData = WeatherUtils.parseWeatherForecast(dayIndex, rawMessage)) != null) {
                try {
                    JSONObject forecastDataJson = WeatherUtils.parseWeatherForecastJson(forecastData);
                    SocketManager.getSocket().emit("C2SWeatherForecastData", new Object[]{forecastDataJson});
                }
                catch (JSONException e) {
                    System.out.println("Failed to serialize weather forecast data : " + e.getMessage());
                }
            }
        }
    }
}

