/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.state;

import io.dampen59.mineboxadditions.features.fishingshoal.FishingShoal;
import io.dampen59.mineboxadditions.features.harvestable.Harvestable;
import io.dampen59.mineboxadditions.features.item.MineboxItem;
import io.dampen59.mineboxadditions.features.shop.ShopManager;
import io.dampen59.mineboxadditions.features.voicechat.AudioManager;
import io.dampen59.mineboxadditions.state.WeatherState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class State {
    private final WeatherState weatherState = new WeatherState();
    private String shopDisplay = null;
    private int currentMoonPhase = -1;
    private List<MineboxItem> mbxItems = null;
    private Map<String, List<Harvestable>> mbxHarvestables = new HashMap<String, List<Harvestable>>();
    private List<FishingShoal.Item> shoalItems = new ArrayList<FishingShoal.Item>();
    private final Map<String, Boolean> mbxShiniesUuids = new HashMap<String, Boolean>();
    private AudioManager audioManager = null;
    private String lastSentCommand = null;
    private String lockedItemId = null;
    private int lockedItemQuantity = 1;
    private Integer lockedItemScrollOffset = null;
    private Set<String> lockedCollapsedKeys = new HashSet<String>();
    private List<String> missingMuseumItemIds = new ArrayList<String>();
    private final Map<String, String> entityTextCache = new HashMap<String, String>();

    public String getShopDisplay() {
        return this.shopDisplay;
    }

    public void setShopDisplay(String display) {
        this.shopDisplay = display;
    }

    public int getCurrentMoonPhase() {
        return this.currentMoonPhase;
    }

    public void setCurrentMoonPhase(int phase) {
        this.currentMoonPhase = phase;
    }

    public List<MineboxItem> getMbxItems() {
        return this.mbxItems;
    }

    public void setMbxItems(List<MineboxItem> items) {
        this.mbxItems = items;
    }

    public List<Harvestable> getMineboxHarvestables(String islandName) {
        return this.mbxHarvestables.get(islandName);
    }

    public void addMineboxHarvestables(String islandName, List<Harvestable> data) {
        if (this.mbxHarvestables.containsKey(islandName)) {
            this.mbxHarvestables.remove(islandName);
        }
        this.mbxHarvestables.put(islandName, data);
    }

    public Map<String, Boolean> getMbxShiniesUuids() {
        return this.mbxShiniesUuids;
    }

    public void resetShinyList() {
        this.mbxShiniesUuids.clear();
    }

    public void addShinyUuid(String uuid) {
        this.mbxShiniesUuids.put(uuid, false);
    }

    public AudioManager getAudioManager() {
        return this.audioManager;
    }

    public void setAudioManager(AudioManager audioManager) {
        this.audioManager = audioManager;
    }

    public WeatherState getWeatherState() {
        return this.weatherState;
    }

    public void setLastSentCommand(String cmd) {
        this.lastSentCommand = cmd;
    }

    public String getLastSentCommand() {
        return this.lastSentCommand;
    }

    public void setLockedItemId(String id) {
        this.lockedItemId = id;
    }

    public String getLockedItemId() {
        return this.lockedItemId;
    }

    public boolean hasLockedItem() {
        return this.lockedItemId != null;
    }

    public void setLockedItemQuantity(int quantity) {
        if (quantity > 0) {
            this.lockedItemQuantity = quantity;
        }
    }

    public int getLockedItemQuantity() {
        return this.lockedItemQuantity;
    }

    public void setLockedItemScrollOffset(Integer offset) {
        this.lockedItemScrollOffset = offset;
    }

    public Integer getLockedItemScrollOffset() {
        return this.lockedItemScrollOffset;
    }

    public Set<String> getLockedCollapsedKeys() {
        return this.lockedCollapsedKeys;
    }

    public void setLockedCollapsedKeys(Set<String> keys) {
        this.lockedCollapsedKeys = keys == null ? new HashSet<String>() : new HashSet<String>(keys);
    }

    public MineboxItem getItemById(String id) {
        if (this.mbxItems == null) {
            return null;
        }
        return this.mbxItems.stream().filter(i -> id.equals(i.getId())).findFirst().orElse(null);
    }

    public void cacheEntityText(String uuid, String text) {
        this.entityTextCache.put(uuid, text);
    }

    public String getCachedEntityText(String uuid) {
        return this.entityTextCache.get(uuid);
    }

    public boolean hasEntityTextCached(String uuid) {
        return this.entityTextCache.containsKey(uuid);
    }

    public void cleanStaleEntityTextCache(Set<String> liveUuids) {
        this.entityTextCache.keySet().removeIf(uuid -> !liveUuids.contains(uuid));
    }

    public List<String> getMissingMuseumItemIds() {
        return this.missingMuseumItemIds;
    }

    public void setMissingMuseumItemIds(List<String> ids) {
        this.missingMuseumItemIds = ids == null ? new ArrayList<String>() : new ArrayList<String>(ids);
    }

    public void reset() {
        ShopManager.reset();
        this.setShopDisplay(null);
        this.setCurrentMoonPhase(-1);
        this.resetShinyList();
        this.weatherState.clear();
        this.missingMuseumItemIds.clear();
    }
}

