/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.utils;

import io.dampen59.mineboxadditions.config.items.ItemsConfig;
import java.awt.Color;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_7417;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class RaritiesUtils {
    public static final Map<String, Integer> RARITY_ARGB = Map.of("common", -10070938, "uncommon", -16727953, "rare", -16734724, "epic", -518404, "legendary", -16843, "mythic", -6289910);

    public static int percentToAlpha(double p) {
        return (int)Math.round(2.55 * p);
    }

    public static Color adjustAlpha(Color color, double percentage) {
        int newAlpha = RaritiesUtils.percentToAlpha(percentage);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), newAlpha);
    }

    public static Color getRarityColor(String rarity) {
        if (rarity == null) {
            return null;
        }
        Integer base = RARITY_ARGB.get(rarity.toLowerCase());
        if (base == null) {
            return null;
        }
        double opacityCfg = ItemsConfig.rarity.opacity;
        double opacity = opacityCfg > 1.0 ? opacityCfg / 100.0 : opacityCfg;
        opacity = Math.max(0.0, Math.min(1.0, opacity));
        int a = (int)Math.round(255.0 * opacity);
        int rgb = base & 0xFFFFFF;
        int argb = a << 24 | rgb;
        return new Color(argb, true);
    }

    public static Color getItemRarityColorFromLore(class_1799 itemStack) {
        class_9290 loreComponent = (class_9290)itemStack.method_58694(class_9334.field_49632);
        if (loreComponent == null) {
            return null;
        }
        String PREFIX = "mbx.rarities.";
        String SUFFIX = ".icon";
        for (class_2561 loreLine : loreComponent.comp_2400()) {
            String key;
            String string;
            class_7417 class_74172 = loreLine.method_10851();
            if (class_74172 instanceof class_2588) {
                class_2588 translatable = (class_2588)class_74172;
                string = translatable.method_11022();
            } else {
                string = loreLine.getString();
            }
            if (!(key = string).startsWith("mbx.rarities.") || !key.endsWith(".icon")) continue;
            String rarity = key.substring("mbx.rarities.".length(), key.length() - ".icon".length());
            return RaritiesUtils.getRarityColor(rarity);
        }
        return null;
    }
}

