/*
 * Decompiled with CFR 0.152.
 */
package io.dampen59.mineboxadditions.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.maxhenkel.opus4j.OpusDecoder;
import io.dampen59.mineboxadditions.MineboxAdditions;
import io.dampen59.mineboxadditions.config.Config;
import io.dampen59.mineboxadditions.features.harvestable.Harvestable;
import io.dampen59.mineboxadditions.features.item.MineboxItem;
import io.dampen59.mineboxadditions.features.shop.ShopManager;
import io.dampen59.mineboxadditions.features.voicechat.AudioManager;
import io.dampen59.mineboxadditions.utils.AudioUtils;
import io.dampen59.mineboxadditions.utils.Utils;
import io.socket.client.IO;
import io.socket.client.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;

@Environment(value=EnvType.CLIENT)
public class SocketManager {
    private static Socket socket;
    private static final int protocol = 10;
    private static final ObjectMapper mapper;

    @NotNull
    public static Socket getSocket() {
        if (socket == null) {
            SocketManager.init();
        }
        return socket;
    }

    public static void init() {
        socket = IO.socket((URI)URI.create(Config.socketServerAddress), (IO.Options)IO.Options.builder().build());
        socket.on("connect", args -> {
            class_310 client = class_310.method_1551();
            if (client != null && client.field_1724 != null) {
                String playerName = client.field_1724.method_5477().getString();
                String playerUuid = client.field_1724.method_5667().toString();
                String playerLang = client.method_1526().method_4669();
                socket.emit("C2SHelloConnectMessage", new Object[]{playerUuid, playerName, playerLang, 10});
            }
        });
        socket.on("S2CProtocolMismatch", args -> Utils.showToastNotification(class_2561.method_43471((String)"mineboxadditions.strings.update.title").getString(), class_2561.method_43471((String)"mineboxadditions.strings.update.content").getString()));
        socket.on("S2CMineboxItemsStats", args -> {
            String jsonData = (String)args[0];
            try {
                List itemsList = (List)mapper.readValue(jsonData, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, MineboxItem.class));
                MineboxAdditions.INSTANCE.state.setMbxItems(itemsList);
            }
            catch (JsonProcessingException e) {
                System.out.println("[SocketManager] Failed to load Minebox Items Stats JSON: " + e.getMessage());
            }
        });
        socket.on("S2CAudioData", args -> {
            String playerName = (String)args[0];
            byte[] audioData = (byte[])args[1];
            try {
                OpusDecoder decoder = MineboxAdditions.INSTANCE.state.getAudioManager().getDecoders().computeIfAbsent(playerName, name -> {
                    try {
                        return new OpusDecoder(48000, 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                });
                if (decoder == null) {
                    return;
                }
                AudioUtils.playAudio(decoder, audioData, playerName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        socket.on("S2CHarvestableData", args -> {
            String islandName = (String)args[0];
            String jsonData = (String)args[1];
            try {
                List items = (List)mapper.readValue(jsonData, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, Harvestable.class));
                MineboxAdditions.INSTANCE.state.addMineboxHarvestables(islandName, items);
            }
            catch (Exception e) {
                System.out.println("[SocketManager] Failed to load Harvestables JSON: " + e.getMessage());
            }
        });
        socket.on("S2CProximityAudioData", args -> {
            String playerName = (String)args[0];
            byte[] audioData = (byte[])args[1];
            try {
                class_1657 sourcePlayer = AudioUtils.getNearbyPlayer(playerName);
                if (sourcePlayer == null) {
                    return;
                }
                float volumeMultiplier = AudioUtils.computeVolumeMultiplier(sourcePlayer);
                OpusDecoder decoder = MineboxAdditions.INSTANCE.state.getAudioManager().getDecoders().computeIfAbsent(playerName, name -> {
                    try {
                        return new OpusDecoder(48000, 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                });
                if (decoder == null) {
                    return;
                }
                AudioUtils.playProximityAudio(decoder, audioData, volumeMultiplier, sourcePlayer, playerName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        socket.on("S2CAudioRoomCreated", args -> {
            String roomCode = (String)args[0];
            Utils.displayChatSuccessMessage(class_2561.method_43469((String)"mineboxadditions.strings.audiochannel.create.success", (Object[])new Object[]{roomCode}).getString());
            try {
                AudioManager audioManager = MineboxAdditions.INSTANCE.state.getAudioManager();
                Mixer speakerMixer = AudioUtils.getMixerByName(Config.selectedSpeakerName);
                if (speakerMixer != null) {
                    audioManager.openSpeaker(speakerMixer);
                } else {
                    audioManager.openSpeaker();
                }
                Mixer micMixer = AudioUtils.getMixerByName(Config.selectedMicName);
                if (micMixer != null) {
                    audioManager.openMicrophone(micMixer);
                } else {
                    audioManager.openMicrophone();
                }
            }
            catch (LineUnavailableException e) {
                SocketManager.getSocket().emit("C2SLeaveAudioRoom", new Object[0]);
                Utils.displayChatErrorMessage("You have left the voice channel because MineboxAdditions was not able to setup your Speakers and/or Microphone. Please check your game logs.");
                MineboxAdditions.LOGGER.error("[SocketManager] Failed to open Speaker or Microphone : {}", (Object)e.getMessage());
            }
        });
        socket.on("S2CAudioRoomJoined", args -> {
            String roomCode = (String)args[0];
            Utils.displayChatSuccessMessage(class_2561.method_43469((String)"mineboxadditions.strings.audiochannel.join.success", (Object[])new Object[]{roomCode}).getString());
            try {
                AudioManager audioManager = MineboxAdditions.INSTANCE.state.getAudioManager();
                Mixer speakerMixer = AudioUtils.getMixerByName(Config.selectedSpeakerName);
                if (speakerMixer != null) {
                    audioManager.openSpeaker(speakerMixer);
                } else {
                    audioManager.openSpeaker();
                }
                Mixer micMixer = AudioUtils.getMixerByName(Config.selectedMicName);
                if (micMixer != null) {
                    audioManager.openMicrophone(micMixer);
                } else {
                    audioManager.openMicrophone();
                }
            }
            catch (LineUnavailableException e) {
                SocketManager.getSocket().emit("C2SLeaveAudioRoom", new Object[0]);
                Utils.displayChatErrorMessage("You have left the voice channel because MineboxAdditions was not able to setup your Speakers and/or Microphone. Please check your game logs.");
                MineboxAdditions.LOGGER.error("[SocketManager] Failed to open Speaker or Microphone : {}", (Object)e.getMessage());
            }
        });
        socket.on("S2CProximityAudioToggled", args -> {
            block8: {
                boolean isEnabled = (Boolean)args[0];
                if (isEnabled) {
                    Utils.displayChatSuccessMessage(class_2561.method_43471((String)"mineboxadditions.strings.audiochannel.proximity.enabled").getString());
                    AudioManager audioManager = MineboxAdditions.INSTANCE.state.getAudioManager();
                    try {
                        if (audioManager.getSpeaker() == null || !audioManager.getSpeaker().isOpen()) {
                            Mixer speakerMixer = AudioUtils.getMixerByName(Config.selectedSpeakerName);
                            if (speakerMixer != null) {
                                audioManager.openSpeaker(speakerMixer);
                            } else {
                                audioManager.openSpeaker();
                            }
                        }
                        if (audioManager.getMicrophone() != null && audioManager.getMicrophone().isOpen()) break block8;
                        Mixer micMixer = AudioUtils.getMixerByName(Config.selectedMicName);
                        if (micMixer != null) {
                            audioManager.openMicrophone(micMixer);
                            break block8;
                        }
                        audioManager.openMicrophone();
                    }
                    catch (LineUnavailableException e) {
                        e.printStackTrace();
                    }
                } else {
                    MineboxAdditions.INSTANCE.state.getAudioManager().closeMicrophoneAndSpeaker();
                    Utils.displayChatErrorMessage(class_2561.method_43471((String)"mineboxadditions.strings.audiochannel.proximity.disabled").getString());
                }
            }
        });
        socket.on("S2CJoinAudioRoomFailed", args -> {
            String roomCode = (String)args[0];
            Utils.displayChatErrorMessage(class_2561.method_43469((String)"mineboxadditions.strings.audiochannel.join.failed", (Object[])new Object[]{roomCode}).getString());
        });
        socket.on("S2CAudioRoomCreationFailed", args -> Utils.displayChatErrorMessage(class_2561.method_43471((String)"mineboxadditions.strings.audiochannel.create.failed").getString()));
        socket.on("S2CAudioClientConnected", args -> {
            String playerName = (String)args[0];
            Utils.displayChatInfoMessage(class_2561.method_43469((String)"mineboxadditions.strings.audiochannel.user.connected", (Object[])new Object[]{playerName}).getString());
        });
        socket.on("S2CLeaveAudioRoomFailed", args -> Utils.displayChatErrorMessage(class_2561.method_43471((String)"mineboxadditions.strings.audiochannel.leave.failed").getString()));
        socket.on("S2CEnableProximityAudioFailedLeaveFirst", args -> Utils.displayChatErrorMessage(class_2561.method_43471((String)"mineboxadditions.strings.audiochannel.proximity.enable.fail.leavefirst").getString()));
        socket.on("S2CCreateJoinAudioRoomFailedDisableProximityFirst", args -> Utils.displayChatErrorMessage(class_2561.method_43471((String)"mineboxadditions.strings.audiochannel.join.fail.leavefirst").getString()));
        socket.on("S2CAudioRoomLeft", args -> {
            String roomCode = (String)args[0];
            Utils.displayChatSuccessMessage(class_2561.method_43469((String)"mineboxadditions.strings.audiochannel.leave.success", (Object[])new Object[]{roomCode}).getString());
            MineboxAdditions.INSTANCE.state.getAudioManager().closeMicrophoneAndSpeaker();
        });
        socket.on("S2CAudioClientDisconnected", args -> {
            String playerName = (String)args[0];
            Utils.displayChatInfoMessage(class_2561.method_43469((String)"mineboxadditions.strings.audiochannel.user.disconnected", (Object[])new Object[]{playerName}).getString());
        });
        socket.on("S2CWeatherData", args -> {
            String weather = (String)args[0];
            Integer timestamp = Integer.parseInt(args[1].toString());
            switch (weather) {
                case "RAIN": {
                    MineboxAdditions.INSTANCE.state.getWeatherState().addRainTimestamp(timestamp);
                    break;
                }
                case "STORM": {
                    MineboxAdditions.INSTANCE.state.getWeatherState().addRainTimestamp(timestamp);
                    MineboxAdditions.INSTANCE.state.getWeatherState().addStormTimestamp(timestamp);
                    break;
                }
                default: {
                    System.out.println("Received unknown weather data : " + weather);
                }
            }
        });
        socket.on("S2ClearWeatherData", args -> MineboxAdditions.INSTANCE.state.getWeatherState().clear());
        socket.on("S2CMotd", args -> {
            String message = (String)args[0];
            Utils.displayChatInfoMessage("[MineboxAdditions MOTD] " + message);
        });
        socket.on("S2CMermaidRequest", args -> {
            int itemQuantity = (Integer)args[0];
            String itemTranslationKey = (String)args[1];
            String itemTranslationKeyArgs = args[2] instanceof String ? (String)args[2] : null;
            ShopManager.getMermaid().set(itemQuantity, itemTranslationKey, itemTranslationKeyArgs);
        });
        socket.on("S2CMineboxApiUnauthorized", args -> Utils.displayChatErrorMessage(class_2561.method_43471((String)"mineboxadditions.strings.errors.unauthorized-api").getString()));
        socket.on("S2CMissingMuseumItems", args -> {
            ArrayList<String> itemIds = new ArrayList<String>();
            Object payload = args[0];
            JSONArray arr = (JSONArray)payload;
            for (int i = 0; i < arr.length(); ++i) {
                String id = arr.optString(i, null);
                if (id == null || id.isEmpty()) continue;
                itemIds.add(id);
            }
            MineboxAdditions.INSTANCE.state.setMissingMuseumItemIds(itemIds);
        });
    }

    static {
        mapper = new ObjectMapper();
    }
}

