/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.config;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.dvs.versioning.BasicVersioning;
import dev.dejvokep.boostedyaml.settings.dumper.DumperSettings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public class APConfig {
    private final YamlDocument document;

    public APConfig(File folder, ClassLoader loader) throws IOException {
        this.document = YamlDocument.create(new File(folder, "config.yml"), Objects.requireNonNull(loader.getResourceAsStream("config.yml")), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("config-version")).build());
    }

    public boolean isBstats() {
        return this.document.getBoolean("bstats");
    }

    public boolean isFilterNotSecure() {
        return this.document.getBoolean("filter-not-secure");
    }

    public boolean isSendHeader() {
        return this.document.getBoolean("send-header");
    }

    public boolean isAutoSetup() {
        return this.document.getBoolean("auto-setup");
    }

    public boolean isBlockChatReports() {
        return this.document.getBoolean("block-chat-reports");
    }

    public void setBlockChatReports(boolean value) {
        this.document.set("block-chat-reports", (Object)value);
    }

    public boolean isClickableUrls() {
        return this.document.getBoolean("clickable-urls");
    }

    public String getPropertiesLocation() {
        return this.document.getString("properties-location");
    }

    public boolean isFirstRun() {
        return this.document.getBoolean("first-run");
    }

    public void setFirstRun(boolean value) {
        this.document.set("first-run", (Object)value);
    }

    public boolean isAskBstats() {
        return this.document.getBoolean("ask-bstats");
    }

    public void setAskBstats(boolean value) {
        this.document.set("ask-bstats", (Object)value);
    }

    public boolean isSetupMode() {
        return this.document.getBoolean("setup-mode");
    }

    public void setSetupMode(boolean value) {
        this.document.set("setup-mode", (Object)value);
    }

    public boolean isShowPopup() {
        return this.document.getBoolean("show-popup");
    }

    public boolean isExperimentalMode() {
        return this.document.getOptionalBoolean("experimental-mode").orElse(false);
    }

    public void save() {
        try {
            this.document.save();
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not save the config.", ex);
        }
    }

    public void reload() {
        try {
            this.document.reload();
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not reload the config.", ex);
        }
    }
}

