/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.libs.folialib.impl;

import com.github.kaspiandev.antipopup.libs.folialib.FoliaLib;
import com.github.kaspiandev.antipopup.libs.folialib.enums.EntityTaskResult;
import com.github.kaspiandev.antipopup.libs.folialib.impl.ServerImplementation;
import com.github.kaspiandev.antipopup.libs.folialib.util.TimeConverter;
import com.github.kaspiandev.antipopup.libs.folialib.wrapper.WrappedTask;
import com.github.kaspiandev.antipopup.libs.folialib.wrapper.task.WrappedFoliaTask;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class FoliaImplementation
implements ServerImplementation {
    private final JavaPlugin plugin;
    private final GlobalRegionScheduler globalRegionScheduler;
    private final AsyncScheduler asyncScheduler;

    public FoliaImplementation(FoliaLib foliaLib) {
        this.plugin = foliaLib.getPlugin();
        this.globalRegionScheduler = this.plugin.getServer().getGlobalRegionScheduler();
        this.asyncScheduler = this.plugin.getServer().getAsyncScheduler();
    }

    @Override
    public CompletableFuture<Void> runNextTick(Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.globalRegionScheduler.execute((Plugin)this.plugin, () -> {
            runnable.run();
            future.complete(null);
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> runAsync(Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.asyncScheduler.runNow((Plugin)this.plugin, task -> {
            runnable.run();
            future.complete(null);
        });
        return future;
    }

    @Override
    public WrappedTask runLater(Runnable runnable, long delay, TimeUnit unit) {
        return new WrappedFoliaTask(this.globalRegionScheduler.runDelayed((Plugin)this.plugin, task -> runnable.run(), TimeConverter.toTicks(delay, unit)));
    }

    @Override
    public WrappedTask runLaterAsync(Runnable runnable, long delay, TimeUnit unit) {
        return new WrappedFoliaTask(this.asyncScheduler.runDelayed((Plugin)this.plugin, task -> runnable.run(), delay, unit));
    }

    @Override
    public WrappedTask runTimer(Runnable runnable, long delay, long period, TimeUnit unit) {
        return new WrappedFoliaTask(this.globalRegionScheduler.runAtFixedRate((Plugin)this.plugin, task -> runnable.run(), TimeConverter.toTicks(delay, unit), TimeConverter.toTicks(period, unit)));
    }

    @Override
    public WrappedTask runTimerAsync(Runnable runnable, long delay, long period, TimeUnit unit) {
        return new WrappedFoliaTask(this.asyncScheduler.runAtFixedRate((Plugin)this.plugin, task -> runnable.run(), delay, period, unit));
    }

    @Override
    public CompletableFuture<Void> runAtLocation(Location location, Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.plugin.getServer().getRegionScheduler().execute((Plugin)this.plugin, location, () -> {
            runnable.run();
            future.complete(null);
        });
        return future;
    }

    @Override
    public WrappedTask runAtLocationLater(Location location, Runnable runnable, long delay, TimeUnit unit) {
        return new WrappedFoliaTask(this.plugin.getServer().getRegionScheduler().runDelayed((Plugin)this.plugin, location, task -> runnable.run(), TimeConverter.toTicks(delay, unit)));
    }

    @Override
    public WrappedTask runAtLocationTimer(Location location, Runnable runnable, long delay, long period, TimeUnit unit) {
        return new WrappedFoliaTask(this.plugin.getServer().getRegionScheduler().runAtFixedRate((Plugin)this.plugin, location, task -> runnable.run(), TimeConverter.toTicks(delay, unit), TimeConverter.toTicks(period, unit)));
    }

    @Override
    public CompletableFuture<EntityTaskResult> runAtEntity(Entity entity, Runnable runnable) {
        CompletableFuture<EntityTaskResult> future = new CompletableFuture<EntityTaskResult>();
        boolean success = entity.getScheduler().execute((Plugin)this.plugin, () -> {
            runnable.run();
            future.complete(EntityTaskResult.SUCCESS);
        }, null, 0L);
        if (!success) {
            future.complete(EntityTaskResult.SCHEDULER_RETIRED);
        }
        return future;
    }

    @Override
    public CompletableFuture<EntityTaskResult> runAtEntityWithFallback(Entity entity, Runnable runnable, Runnable fallback) {
        CompletableFuture<EntityTaskResult> future = new CompletableFuture<EntityTaskResult>();
        boolean success = entity.getScheduler().execute((Plugin)this.plugin, () -> {
            runnable.run();
            future.complete(EntityTaskResult.SUCCESS);
        }, () -> {
            fallback.run();
            future.complete(EntityTaskResult.ENTITY_RETIRED);
        }, 0L);
        if (!success) {
            future.complete(EntityTaskResult.SCHEDULER_RETIRED);
        }
        return future;
    }

    @Override
    public WrappedTask runAtEntityLater(Entity entity, Runnable runnable, long delay, TimeUnit unit) {
        return new WrappedFoliaTask(entity.getScheduler().runDelayed((Plugin)this.plugin, task -> runnable.run(), null, TimeConverter.toTicks(delay, unit)));
    }

    @Override
    public WrappedTask runAtEntityTimer(Entity entity, Runnable runnable, long delay, long period, TimeUnit unit) {
        return new WrappedFoliaTask(entity.getScheduler().runAtFixedRate((Plugin)this.plugin, task -> runnable.run(), null, TimeConverter.toTicks(delay, unit), TimeConverter.toTicks(period, unit)));
    }

    @Override
    public void cancelTask(WrappedTask task) {
        task.cancel();
    }

    @Override
    public void cancelAllTasks() {
        this.globalRegionScheduler.cancelTasks((Plugin)this.plugin);
        this.asyncScheduler.cancelTasks((Plugin)this.plugin);
    }

    @Override
    public Player getPlayer(String name) {
        return this.plugin.getServer().getPlayer(name);
    }

    @Override
    public Player getPlayerExact(String name) {
        return this.plugin.getServer().getPlayerExact(name);
    }

    @Override
    public Player getPlayer(UUID uuid) {
        return this.plugin.getServer().getPlayer(uuid);
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Player player, Location location) {
        return player.teleportAsync(location);
    }
}

