/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.libs.folialib.impl;

import com.github.kaspiandev.antipopup.libs.folialib.FoliaLib;
import com.github.kaspiandev.antipopup.libs.folialib.enums.EntityTaskResult;
import com.github.kaspiandev.antipopup.libs.folialib.impl.ServerImplementation;
import com.github.kaspiandev.antipopup.libs.folialib.util.TimeConverter;
import com.github.kaspiandev.antipopup.libs.folialib.wrapper.WrappedTask;
import com.github.kaspiandev.antipopup.libs.folialib.wrapper.task.WrappedBukkitTask;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;

public class SpigotImplementation
implements ServerImplementation {
    private final JavaPlugin plugin;
    @NotNull
    private final BukkitScheduler scheduler;

    public SpigotImplementation(FoliaLib foliaLib) {
        this.plugin = foliaLib.getPlugin();
        this.scheduler = this.plugin.getServer().getScheduler();
    }

    @Override
    public CompletableFuture<Void> runNextTick(Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.scheduler.runTask((Plugin)this.plugin, () -> {
            runnable.run();
            future.complete(null);
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> runAsync(Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.scheduler.runTaskAsynchronously((Plugin)this.plugin, () -> {
            runnable.run();
            future.complete(null);
        });
        return future;
    }

    @Override
    public WrappedTask runLater(Runnable runnable, long delay, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskLater((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit)));
    }

    @Override
    public WrappedTask runLaterAsync(Runnable runnable, long delay, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskLaterAsynchronously((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit)));
    }

    @Override
    public WrappedTask runTimer(Runnable runnable, long delay, long period, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskTimer((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit), TimeConverter.toTicks(period, unit)));
    }

    @Override
    public WrappedTask runTimerAsync(Runnable runnable, long delay, long period, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskTimerAsynchronously((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit), TimeConverter.toTicks(period, unit)));
    }

    @Override
    public CompletableFuture<Void> runAtLocation(Location location, Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.scheduler.runTask((Plugin)this.plugin, () -> {
            runnable.run();
            future.complete(null);
        });
        return future;
    }

    @Override
    public WrappedTask runAtLocationLater(Location location, Runnable runnable, long delay, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskLater((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit)));
    }

    @Override
    public WrappedTask runAtLocationTimer(Location location, Runnable runnable, long delay, long period, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskTimer((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit), TimeConverter.toTicks(period, unit)));
    }

    @Override
    public CompletableFuture<EntityTaskResult> runAtEntity(Entity entity, Runnable runnable) {
        CompletableFuture<EntityTaskResult> future = new CompletableFuture<EntityTaskResult>();
        this.scheduler.runTask((Plugin)this.plugin, () -> {
            runnable.run();
            future.complete(EntityTaskResult.SUCCESS);
        });
        return future;
    }

    @Override
    public CompletableFuture<EntityTaskResult> runAtEntityWithFallback(Entity entity, Runnable runnable, Runnable fallback) {
        CompletableFuture<EntityTaskResult> future = new CompletableFuture<EntityTaskResult>();
        this.scheduler.runTask((Plugin)this.plugin, () -> {
            if (entity.isValid()) {
                runnable.run();
                future.complete(EntityTaskResult.SUCCESS);
            } else {
                fallback.run();
                future.complete(EntityTaskResult.ENTITY_RETIRED);
            }
        });
        return future;
    }

    @Override
    public WrappedTask runAtEntityLater(Entity entity, Runnable runnable, long delay, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskLater((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit)));
    }

    @Override
    public WrappedTask runAtEntityTimer(Entity entity, Runnable runnable, long delay, long period, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskTimer((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit), TimeConverter.toTicks(period, unit)));
    }

    @Override
    public void cancelTask(WrappedTask task) {
        task.cancel();
    }

    @Override
    public void cancelAllTasks() {
        this.scheduler.cancelTasks((Plugin)this.plugin);
    }

    @Override
    public Player getPlayer(String name) {
        if (this.plugin.getServer().isPrimaryThread()) {
            return this.plugin.getServer().getPlayer(name);
        }
        try {
            return (Player)this.scheduler.callSyncMethod((Plugin)this.plugin, () -> this.plugin.getServer().getPlayer(name)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Player getPlayerExact(String name) {
        if (this.plugin.getServer().isPrimaryThread()) {
            return this.plugin.getServer().getPlayerExact(name);
        }
        try {
            return (Player)this.scheduler.callSyncMethod((Plugin)this.plugin, () -> this.plugin.getServer().getPlayerExact(name)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Player getPlayer(UUID uuid) {
        if (this.plugin.getServer().isPrimaryThread()) {
            return this.plugin.getServer().getPlayer(uuid);
        }
        try {
            return (Player)this.scheduler.callSyncMethod((Plugin)this.plugin, () -> this.plugin.getServer().getPlayer(uuid)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Player player, Location location) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.runAtEntity((Entity)player, () -> {
            if (player.isValid() && player.isOnline()) {
                player.teleport(location);
                future.complete(true);
            } else {
                future.complete(false);
            }
        });
        return future;
    }
}

