/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.component.builtin.item;

import com.github.kaspiandev.antipopup.libs.packetevents.api.manager.server.ServerVersion;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.color.Color;
import com.github.kaspiandev.antipopup.libs.packetevents.api.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

public class ItemCustomModelData {
    private List<Float> floats;
    private List<Boolean> flags;
    private List<String> strings;
    private List<Color> colors;

    public ItemCustomModelData(List<Float> floats, List<Boolean> flags, List<String> strings, List<Color> colors) {
        this.floats = floats;
        this.flags = flags;
        this.strings = strings;
        this.colors = colors;
    }

    public ItemCustomModelData(int legacyId) {
        this.floats = new ArrayList<Float>(1);
        this.flags = new ArrayList<Boolean>(0);
        this.strings = new ArrayList<String>(0);
        this.colors = new ArrayList<Color>(0);
        this.setLegacyId(legacyId);
    }

    public static ItemCustomModelData read(PacketWrapper<?> wrapper) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_4)) {
            return new ItemCustomModelData(wrapper.readList(PacketWrapper::readFloat), wrapper.readList(PacketWrapper::readBoolean), wrapper.readList(PacketWrapper::readString), wrapper.readList(Color::read));
        }
        return new ItemCustomModelData(wrapper.readVarInt());
    }

    public static void write(PacketWrapper<?> wrapper, ItemCustomModelData data) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_4)) {
            wrapper.writeList(data.floats, PacketWrapper::writeFloat);
            wrapper.writeList(data.flags, PacketWrapper::writeBoolean);
            wrapper.writeList(data.strings, PacketWrapper::writeString);
            wrapper.writeList(data.colors, Color::write);
        } else {
            wrapper.writeVarInt(data.getLegacyId());
        }
    }

    public List<Float> getFloats() {
        return this.floats;
    }

    public void setFloats(List<Float> floats) {
        this.floats = floats;
    }

    public List<Boolean> getFlags() {
        return this.flags;
    }

    public void setFlags(List<Boolean> flags) {
        this.flags = flags;
    }

    public List<String> getStrings() {
        return this.strings;
    }

    public void setStrings(List<String> strings) {
        this.strings = strings;
    }

    public List<Color> getColors() {
        return this.colors;
    }

    public void setColors(List<Color> colors) {
        this.colors = colors;
    }

    @ApiStatus.Obsolete
    public int getLegacyId() {
        if (!this.floats.isEmpty()) {
            return this.floats.get(0).intValue();
        }
        return 0;
    }

    @ApiStatus.Obsolete
    public void setLegacyId(int legacyId) {
        if (this.flags.isEmpty()) {
            this.floats.add(Float.valueOf(legacyId));
        } else {
            this.floats.set(0, Float.valueOf(legacyId));
        }
    }
}

