/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.debug.struct;

import com.github.kaspiandev.antipopup.libs.packetevents.api.wrapper.PacketWrapper;
import java.util.List;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class DebugGoalInfo {
    private final List<DebugGoal> goals;

    public DebugGoalInfo(List<DebugGoal> goals) {
        this.goals = goals;
    }

    public static DebugGoalInfo read(PacketWrapper<?> wrapper) {
        List<DebugGoal> goals = wrapper.readList(DebugGoal::read);
        return new DebugGoalInfo(goals);
    }

    public static void write(PacketWrapper<?> wrapper, DebugGoalInfo info) {
        wrapper.writeList(info.goals, DebugGoal::write);
    }

    public List<DebugGoal> getGoals() {
        return this.goals;
    }

    public static final class DebugGoal {
        private final int priority;
        private final boolean running;
        private final String name;

        public DebugGoal(int priority, boolean running, String name) {
            this.priority = priority;
            this.running = running;
            this.name = name;
        }

        public static DebugGoal read(PacketWrapper<?> wrapper) {
            int priority = wrapper.readVarInt();
            boolean running = wrapper.readBoolean();
            String name = wrapper.readString(255);
            return new DebugGoal(priority, running, name);
        }

        public static void write(PacketWrapper<?> wrapper, DebugGoal goal) {
            wrapper.writeVarInt(goal.priority);
            wrapper.writeBoolean(goal.running);
            wrapper.writeString(goal.name, 255);
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isRunning() {
            return this.running;
        }

        public String getName() {
            return this.name;
        }
    }
}

