/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.dialog.body;

import com.github.kaspiandev.antipopup.libs.kyori.adventure.text.Component;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.nbt.NBT;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.nbt.NBTCompound;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.nbt.NBTInt;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.adventure.AdventureSerializer;
import com.github.kaspiandev.antipopup.libs.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PlainMessage {
    private final Component contents;
    private final int width;

    public PlainMessage(Component contents, int width) {
        this.contents = contents;
        this.width = width;
    }

    public static PlainMessage decode(NBT nbt, PacketWrapper<?> wrapper) {
        return PlainMessage.decode((NBTCompound)nbt, wrapper);
    }

    public static PlainMessage decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        Component contents = compound.getOrThrow("contents", AdventureSerializer.serializer(wrapper), wrapper);
        int width = compound.getNumberTagValueOrDefault("width", 200).intValue();
        return new PlainMessage(contents, width);
    }

    public static NBT encode(PacketWrapper<?> wrapper, PlainMessage message) {
        NBTCompound compound = new NBTCompound();
        PlainMessage.encode(compound, wrapper, message);
        return compound;
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, PlainMessage message) {
        compound.set("contents", message.contents, AdventureSerializer.serializer(wrapper), wrapper);
        if (message.width != 200) {
            compound.setTag("width", new NBTInt(message.width));
        }
    }

    public Component getContents() {
        return this.contents;
    }

    public int getWidth() {
        return this.width;
    }
}

