/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.item.enchantment.type;

import com.github.kaspiandev.antipopup.libs.kyori.adventure.text.Component;
import com.github.kaspiandev.antipopup.libs.packetevents.api.PacketEvents;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.component.StaticComponentMap;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.item.enchantment.EnchantmentDefinition;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.item.enchantment.type.EnchantmentType;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.item.enchantment.type.EnchantmentTypes;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.mapper.AbstractMappedEntity;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.mapper.MappedEntityRefSet;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.mapper.MappedEntitySet;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.mapper.ResolvableEntity;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.mappings.GlobalRegistryHolder;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.mappings.TypesBuilderData;
import com.github.kaspiandev.antipopup.libs.packetevents.api.wrapper.PacketWrapper;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class StaticEnchantmentType
extends AbstractMappedEntity
implements EnchantmentType,
ResolvableEntity {
    private final Component description;
    private final EnchantmentDefinition definition;
    private final MappedEntityRefSet<EnchantmentType> exclusiveSetRef;
    @Nullable
    private MappedEntitySet<EnchantmentType> exclusiveSet;
    private final StaticComponentMap effects;

    public StaticEnchantmentType(Component description, EnchantmentDefinition definition, MappedEntitySet<EnchantmentType> exclusiveSet, StaticComponentMap effects) {
        this(null, description, definition, exclusiveSet, effects);
    }

    @ApiStatus.Internal
    public StaticEnchantmentType(@Nullable TypesBuilderData data, Component description, EnchantmentDefinition definition, MappedEntityRefSet<EnchantmentType> exclusiveSet, StaticComponentMap effects) {
        super(data);
        this.description = description;
        this.definition = definition;
        this.exclusiveSetRef = exclusiveSet;
        this.effects = effects;
    }

    @Override
    public void doResolve(PacketWrapper<?> wrapper) {
        this.exclusiveSet = this.exclusiveSetRef.resolve(wrapper, EnchantmentTypes.getRegistry());
    }

    @Override
    public EnchantmentType copy(@Nullable TypesBuilderData newData) {
        StaticEnchantmentType type = new StaticEnchantmentType(newData, this.description, this.definition, this.exclusiveSetRef, this.effects);
        type.exclusiveSet = this.exclusiveSet;
        return type;
    }

    @Override
    public Component getDescription() {
        return this.description;
    }

    @Override
    public EnchantmentDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public MappedEntitySet<EnchantmentType> getExclusiveSet() {
        if (this.exclusiveSet == null) {
            this.exclusiveSet = this.exclusiveSetRef.resolve(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), GlobalRegistryHolder.INSTANCE, EnchantmentTypes.getRegistry());
        }
        return this.exclusiveSet;
    }

    @Override
    public MappedEntityRefSet<EnchantmentType> getExclusiveRefSet() {
        return this.exclusiveSetRef;
    }

    @Override
    public StaticComponentMap getEffects() {
        return this.effects;
    }

    @Override
    public boolean deepEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticEnchantmentType)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StaticEnchantmentType that = (StaticEnchantmentType)obj;
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (!this.definition.equals(that.definition)) {
            return false;
        }
        if (!this.exclusiveSetRef.equals(that.exclusiveSetRef)) {
            return false;
        }
        return this.effects.equals(that.effects);
    }

    @Override
    public int deepHashCode() {
        return Objects.hash(super.hashCode(), this.description, this.definition, this.exclusiveSetRef, this.effects);
    }

    @Override
    public String toString() {
        return "StaticEnchantmentType{description=" + this.description + ", definition=" + this.definition + ", exclusiveSetRef=" + this.exclusiveSetRef + ", effects=" + this.effects + "}";
    }
}

