/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.particle.data;

import com.github.kaspiandev.antipopup.libs.packetevents.api.PacketEvents;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.item.type.ItemType;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.particle.data.LegacyConvertible;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.particle.data.ParticleData;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.player.ClientVersion;
import com.github.kaspiandev.antipopup.libs.packetevents.api.wrapper.PacketWrapper;
import java.util.Arrays;

public class LegacyParticleData
extends ParticleData
implements LegacyConvertible {
    private final int[] legacyData;

    public static LegacyParticleData nullValue(int id) {
        int[] data = new int[LegacyParticleData.getSize(id)];
        Arrays.fill(data, 0);
        return new LegacyParticleData(data);
    }

    public static LegacyParticleData ofTwo(int a2, int b2) {
        return new LegacyParticleData(a2, b2);
    }

    public static LegacyParticleData ofOne(int a2) {
        return new LegacyParticleData(a2);
    }

    public static LegacyParticleData zero() {
        return new LegacyParticleData(new int[0]);
    }

    public static LegacyParticleData ofBlock(ItemType type, byte data) {
        return new LegacyParticleData(type.getId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()) | data << 12);
    }

    public static LegacyParticleData ofItem(ItemType type, byte data) {
        return new LegacyParticleData(type.getId(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()), data);
    }

    LegacyParticleData(int ... legacyData) {
        this.legacyData = legacyData;
    }

    public int[] getLegacyData() {
        return this.legacyData;
    }

    public void validate(int id) {
        if (this.legacyData.length != LegacyParticleData.getSize(id)) {
            throw new IllegalArgumentException("Invalid size for type " + id + ": " + this.legacyData.length);
        }
    }

    public static int getSize(int id) {
        if (id == 36) {
            return 2;
        }
        if (id == 37 || id == 38 || id == 46) {
            return 1;
        }
        return 0;
    }

    public static LegacyParticleData read(PacketWrapper<?> wrapper, int typeId) {
        int[] data = new int[LegacyParticleData.getSize(typeId)];
        for (int i = 0; i < data.length; ++i) {
            data[i] = wrapper.readVarInt();
        }
        return new LegacyParticleData(data);
    }

    public static void write(PacketWrapper<?> wrapper, int typeId, LegacyParticleData data) {
        data.validate(typeId);
        for (int i = 0; i < data.legacyData.length; ++i) {
            wrapper.writeVarInt(data.legacyData[i]);
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public LegacyParticleData toLegacy(ClientVersion version) {
        return new LegacyParticleData(this.legacyData);
    }
}

