/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.libs.packetevents.api.util;

import com.github.kaspiandev.antipopup.libs.packetevents.api.PacketEvents;
import com.github.kaspiandev.antipopup.libs.packetevents.api.manager.server.ServerVersion;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.world.BlockFace;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.Vector3d;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.Vector3f;
import com.github.kaspiandev.antipopup.libs.packetevents.api.wrapper.PacketWrapper;
import java.util.Objects;

public class Vector3i {
    public final int x;
    public final int y;
    public final int z;

    public Vector3i() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    @Deprecated
    public Vector3i(long val) {
        this(val, PacketEvents.getAPI().getServerManager().getVersion());
    }

    public Vector3i(long val, ServerVersion serverVersion) {
        int z;
        int y;
        int x = (int)(val >> 38);
        if (serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            y = (int)(val << 52 >> 52);
            z = (int)(val << 26 >> 38);
        } else {
            y = (int)(val >> 26 & 0xFFFL);
            z = (int)(val << 38 >> 38);
        }
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3i(int[] array) {
        if (array.length <= 0) {
            this.x = 0;
            this.y = 0;
            this.z = 0;
            return;
        }
        this.x = array[0];
        if (array.length <= 1) {
            this.y = 0;
            this.z = 0;
            return;
        }
        this.y = array[1];
        this.z = array.length > 2 ? array[2] : 0;
    }

    public static Vector3i read(PacketWrapper<?> wrapper) {
        int x = wrapper.readVarInt();
        int y = wrapper.readVarInt();
        int z = wrapper.readVarInt();
        return new Vector3i(x, y, z);
    }

    public static void write(PacketWrapper<?> wrapper, Vector3i vector) {
        wrapper.writeVarInt(vector.x);
        wrapper.writeVarInt(vector.y);
        wrapper.writeVarInt(vector.z);
    }

    public long getSerializedPosition(ServerVersion serverVersion) {
        if (serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            long x = this.getX() & 0x3FFFFFF;
            long y = this.getY() & 0xFFF;
            long z = this.getZ() & 0x3FFFFFF;
            return x << 38 | z << 12 | y;
        }
        if (serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            return (long)(this.getX() & 0x3FFFFFF) << 38 | (long)(this.getZ() & 0x3FFFFFF) << 12 | (long)(this.getY() & 0xFFF);
        }
        return (long)(this.getX() & 0x3FFFFFF) << 38 | (long)(this.getY() & 0xFFF) << 26 | (long)(this.getZ() & 0x3FFFFFF);
    }

    @Deprecated
    public long getSerializedPosition() {
        return this.getSerializedPosition(PacketEvents.getAPI().getServerManager().getVersion());
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vector3i) {
            Vector3i vec = (Vector3i)obj;
            return this.x == vec.x && this.y == vec.y && this.z == vec.z;
        }
        if (obj instanceof Vector3d) {
            Vector3d vec = (Vector3d)obj;
            return (double)this.x == vec.x && (double)this.y == vec.y && (double)this.z == vec.z;
        }
        if (obj instanceof Vector3f) {
            Vector3f vec = (Vector3f)obj;
            return (float)this.x == vec.x && (float)this.y == vec.y && (float)this.z == vec.z;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public Vector3d toVector3d() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public Vector3i add(int x, int y, int z) {
        return new Vector3i(this.x + x, this.y + y, this.z + z);
    }

    public Vector3i add(Vector3i other) {
        return this.add(other.x, other.y, other.z);
    }

    public Vector3i offset(BlockFace face) {
        return this.add(face.getModX(), face.getModY(), face.getModZ());
    }

    public Vector3i subtract(int x, int y, int z) {
        return new Vector3i(this.x - x, this.y - y, this.z - z);
    }

    public Vector3i subtract(Vector3i other) {
        return this.subtract(other.x, other.y, other.z);
    }

    public Vector3i multiply(int x, int y, int z) {
        return new Vector3i(this.x * x, this.y * y, this.z * z);
    }

    public Vector3i multiply(Vector3i other) {
        return this.multiply(other.x, other.y, other.z);
    }

    public Vector3i multiply(int value) {
        return this.multiply(value, value, value);
    }

    public Vector3i crossProduct(Vector3i other) {
        int newX = this.y * other.z - other.y * this.z;
        int newY = this.z * other.x - other.z * this.x;
        int newZ = this.x * other.y - other.x * this.y;
        return new Vector3i(newX, newY, newZ);
    }

    public int dot(Vector3i other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Vector3i with(Integer x, Integer y, Integer z) {
        return new Vector3i(x == null ? this.x : x, y == null ? this.y : y, z == null ? this.z : z);
    }

    public Vector3i withX(int x) {
        return new Vector3i(x, this.y, this.z);
    }

    public Vector3i withY(int y) {
        return new Vector3i(this.x, y, this.z);
    }

    public Vector3i withZ(int z) {
        return new Vector3i(this.x, this.y, z);
    }

    public String toString() {
        return "X: " + this.x + ", Y: " + this.y + ", Z: " + this.z;
    }

    public static Vector3i zero() {
        return new Vector3i();
    }
}

