/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.libs.packetevents.api.util.mappings;

import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.nbt.NBT;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.nbt.NBTNumber;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.nbt.NBTString;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.nbt.NBTType;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.nbt.serializer.SequentialNBTReader;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.player.ClientVersion;
import com.github.kaspiandev.antipopup.libs.packetevents.api.resources.ResourceLocation;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.VersionMapper;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.mappings.ListDiff;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.mappings.MapDiff;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.mappings.MappingHelper;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.mappings.TypesBuilderData;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.mappings.VersionedRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class TypesBuilder {
    private final String mapPath;
    private Map<ClientVersion, Map<String, Integer>> entries = new HashMap<ClientVersion, Map<String, Integer>>();
    private VersionMapper versionMapper;
    @Nullable
    VersionedRegistry<?> registry;

    public TypesBuilder(String mapPath, boolean lazy) {
        this.mapPath = mapPath;
        if (!lazy) {
            this.load();
        }
    }

    public TypesBuilder(String mapPath) {
        this(mapPath, false);
    }

    public void load() {
        if (this.entries == null) {
            this.entries = new HashMap<ClientVersion, Map<String, Integer>>();
        }
        try (SequentialNBTReader.Compound rootCompound = MappingHelper.decompress("mappings/" + this.mapPath);){
            rootCompound.skipOne();
            SequentialNBTReader.Compound compound = (SequentialNBTReader.Compound)rootCompound.next().getValue();
            int length = ((NBTNumber)compound.next().getValue()).getAsInt();
            SequentialNBTReader.Compound entries = (SequentialNBTReader.Compound)compound.next().getValue();
            ClientVersion[] versions = new ClientVersion[length];
            Object first = entries.next();
            if (((NBT)first.getValue()).getType() == NBTType.LIST) {
                this.loadAsArray((Map.Entry<String, NBT>)first, entries, versions);
            } else {
                this.loadAsMap((Map.Entry<String, NBT>)first, entries, versions);
            }
            this.versionMapper = new VersionMapper(versions);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load mapping files.", e);
        }
    }

    private void loadAsArray(Map.Entry<String, NBT> first, SequentialNBTReader.Compound entries, ClientVersion[] versions) {
        ClientVersion start;
        versions[0] = start = ClientVersion.valueOf(first.getKey());
        ArrayList<String> lastEntries = new ArrayList<String>();
        for (NBT entry : (SequentialNBTReader.List)first.getValue()) {
            lastEntries.add(((NBTString)entry).getValue());
        }
        Consumer<ClientVersion> mapLoader = version -> {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int i = 0; i < lastEntries.size(); ++i) {
                map.put((String)lastEntries.get(i), i);
            }
            this.entries.put((ClientVersion)((Object)version), (Map<String, Integer>)map);
        };
        mapLoader.accept(start);
        int i = 1;
        for (Map.Entry<String, NBT> entry : entries) {
            ClientVersion version2 = ClientVersion.valueOf(entry.getKey());
            versions[i++] = version2;
            List<ListDiff<String>> diff = MappingHelper.createListDiff((SequentialNBTReader.Compound)entry.getValue());
            for (int j = diff.size() - 1; j >= 0; --j) {
                diff.get(j).applyTo(lastEntries);
            }
            mapLoader.accept(version2);
        }
    }

    private void loadAsMap(Map.Entry<String, NBT> first, SequentialNBTReader.Compound entries, ClientVersion[] versions) {
        ClientVersion start;
        versions[0] = start = ClientVersion.valueOf(first.getKey());
        Map<String, Integer> lastEntries = StreamSupport.stream(((SequentialNBTReader.Compound)first.getValue()).spliterator(), false).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((NBTNumber)entry.getValue()).getAsInt()));
        Consumer<ClientVersion> mapLoader = version -> {
            HashMap map = new HashMap(lastEntries);
            this.entries.put((ClientVersion)((Object)version), map);
        };
        mapLoader.accept(start);
        int i = 1;
        for (Map.Entry<String, NBT> entry2 : entries) {
            ClientVersion version2 = ClientVersion.valueOf(entry2.getKey());
            versions[i++] = version2;
            List<MapDiff<String, Integer>> diff = MappingHelper.createDiff((SequentialNBTReader.Compound)entry2.getValue());
            for (MapDiff<String, Integer> d : diff) {
                d.applyTo(lastEntries);
            }
            mapLoader.accept(version2);
        }
    }

    @Nullable
    public VersionedRegistry<?> getRegistry() {
        return this.registry;
    }

    public ClientVersion[] getVersions() {
        return this.versionMapper.getVersions();
    }

    public ClientVersion[] getReversedVersions() {
        return this.versionMapper.getReversedVersions();
    }

    public int getDataIndex(ClientVersion rawVersion) {
        return this.versionMapper.getIndex(rawVersion);
    }

    @VisibleForTesting
    public boolean isMappingDataLoaded() {
        return this.entries != null;
    }

    public void unloadFileMappings() {
        this.entries.clear();
        this.entries = null;
    }

    public TypesBuilderData define(String key) {
        ResourceLocation name = new ResourceLocation(key);
        int[] ids = new int[this.getVersions().length];
        int index = 0;
        for (ClientVersion v : this.getVersions()) {
            int id;
            Map<String, Integer> map = this.entries.get((Object)v);
            ids[index] = map.containsKey(key) ? (id = map.get(key).intValue()) : -1;
            ++index;
        }
        return new TypesBuilderData(this, name, ids);
    }

    @Nullable
    public Map<ClientVersion, Map<String, Integer>> getEntries() {
        return this.entries;
    }
}

