/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.libs.packetevents.api.util.mappings;

import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.mapper.MappedEntity;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.player.ClientVersion;
import com.github.kaspiandev.antipopup.libs.packetevents.api.resources.ResourceLocation;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.mappings.IRegistry;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.mappings.MappingHelper;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.mappings.TypesBuilder;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.mappings.TypesBuilderData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class VersionedRegistry<T extends MappedEntity>
implements IRegistry<T> {
    private final ResourceLocation registryKey;
    private final TypesBuilder typesBuilder;
    private final Map<String, T> typeMap = new HashMap<String, T>();
    private final Map<Byte, Map<Integer, T>> typeIdMap = new HashMap<Byte, Map<Integer, T>>();

    public VersionedRegistry(String registry) {
        this(registry, "registries/" + registry);
    }

    public VersionedRegistry(String registry, String mappingsPath) {
        this(new ResourceLocation(registry), mappingsPath);
    }

    public VersionedRegistry(ResourceLocation registryKey, String mappingsPath) {
        this.registryKey = registryKey;
        this.typesBuilder = new TypesBuilder(mappingsPath);
        this.typesBuilder.registry = this;
    }

    @ApiStatus.Internal
    public <Z extends T> Z define(String name, Function<TypesBuilderData, Z> builder) {
        TypesBuilderData typeData = this.typesBuilder.define(name);
        MappedEntity instance = (MappedEntity)builder.apply(typeData);
        MappingHelper.registerMapping(this.typesBuilder, this.typeMap, this.typeIdMap, typeData, instance);
        return (Z)instance;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public TypesBuilder getTypesBuilder() {
        return this.typesBuilder;
    }

    @ApiStatus.Internal
    public void unloadMappings() {
        this.typesBuilder.unloadFileMappings();
    }

    @Override
    @Nullable
    public T getByName(ResourceLocation name) {
        return (T)((MappedEntity)this.typeMap.get(name.toString()));
    }

    @Override
    @Nullable
    public T getByName(String name) {
        return (T)((MappedEntity)this.typeMap.get(ResourceLocation.normString(name)));
    }

    @Override
    @Nullable
    public T getById(ClientVersion version, int id) {
        int index = this.typesBuilder.getDataIndex(version);
        Map<Integer, T> idMap = this.typeIdMap.get((byte)index);
        return (T)((MappedEntity)idMap.get(id));
    }

    @Override
    public int getId(MappedEntity entity, ClientVersion version) {
        return entity.getId(version);
    }

    @Override
    public Collection<T> getEntries() {
        return Collections.unmodifiableCollection(this.typeMap.values());
    }

    @Override
    public int size() {
        return this.typeMap.size();
    }

    @Override
    public ResourceLocation getRegistryKey() {
        return this.registryKey;
    }

    public String toString() {
        return "VersionedRegistry[" + this.registryKey + ']';
    }
}

