/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.libs.packetevents.api.wrapper.handshaking.client;

import com.github.kaspiandev.antipopup.libs.packetevents.api.event.PacketReceiveEvent;
import com.github.kaspiandev.antipopup.libs.packetevents.api.exception.InvalidHandshakeException;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.ConnectionState;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.packettype.PacketType;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.player.ClientVersion;
import com.github.kaspiandev.antipopup.libs.packetevents.api.wrapper.PacketWrapper;

public class WrapperHandshakingClientHandshake
extends PacketWrapper<WrapperHandshakingClientHandshake> {
    private int protocolVersion;
    private ClientVersion clientVersion;
    private String serverAddress;
    private int serverPort;
    private ConnectionIntention intention;

    public WrapperHandshakingClientHandshake(PacketReceiveEvent event) {
        super(event);
    }

    @Deprecated
    public WrapperHandshakingClientHandshake(int protocolVersion, String serverAddress, int serverPort, ConnectionState nextConnectionState) {
        this(protocolVersion, serverAddress, serverPort, ConnectionIntention.LOGIN);
        this.setNextConnectionState(nextConnectionState);
    }

    public WrapperHandshakingClientHandshake(int protocolVersion, String serverAddress, int serverPort, ConnectionIntention intention) {
        super(PacketType.Handshaking.Client.HANDSHAKE);
        this.protocolVersion = protocolVersion;
        this.clientVersion = ClientVersion.getById(protocolVersion);
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
        this.intention = intention;
    }

    @Override
    public void read() {
        try {
            this.protocolVersion = this.readVarInt();
            this.clientVersion = ClientVersion.getById(this.protocolVersion);
            this.serverAddress = this.readString(Short.MAX_VALUE);
            this.serverPort = this.readUnsignedShort();
            int nextStateIndex = this.readVarInt();
            this.intention = ConnectionIntention.fromId(nextStateIndex);
        }
        catch (Exception e) {
            throw new InvalidHandshakeException();
        }
    }

    @Override
    public void write() {
        this.writeVarInt(this.protocolVersion);
        this.writeString(this.serverAddress, Short.MAX_VALUE);
        this.writeShort(this.serverPort);
        this.writeVarInt(this.intention.getId());
    }

    @Override
    public void copy(WrapperHandshakingClientHandshake wrapper) {
        this.protocolVersion = wrapper.protocolVersion;
        this.clientVersion = wrapper.clientVersion;
        this.serverAddress = wrapper.serverAddress;
        this.serverPort = wrapper.serverPort;
        this.intention = wrapper.intention;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.clientVersion = ClientVersion.getById(protocolVersion);
    }

    @Override
    public ClientVersion getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public void setClientVersion(ClientVersion clientVersion) {
        this.clientVersion = clientVersion;
        this.protocolVersion = clientVersion.getProtocolVersion();
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public ConnectionState getNextConnectionState() {
        return this.intention.getTargetState();
    }

    public void setNextConnectionState(ConnectionState nextConnectionState) {
        switch (nextConnectionState) {
            case LOGIN: {
                this.intention = ConnectionIntention.LOGIN;
                break;
            }
            case STATUS: {
                this.intention = ConnectionIntention.STATUS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal next connection state: " + (Object)((Object)nextConnectionState));
            }
        }
    }

    public ConnectionIntention getIntention() {
        return this.intention;
    }

    public void setIntention(ConnectionIntention intention) {
        this.intention = intention;
    }

    public static enum ConnectionIntention {
        STATUS(1, ConnectionState.STATUS),
        LOGIN(2, ConnectionState.LOGIN),
        TRANSFER(3, ConnectionState.LOGIN);

        private final int id;
        private final ConnectionState targetState;

        private ConnectionIntention(int id, ConnectionState targetState) {
            this.id = id;
            this.targetState = targetState;
        }

        public static ConnectionIntention fromId(int id) {
            switch (id) {
                case 2: {
                    return LOGIN;
                }
                case 1: {
                    return STATUS;
                }
                case 3: {
                    return TRANSFER;
                }
            }
            throw new IllegalArgumentException("Illegal connection intention: " + id);
        }

        public int getId() {
            return this.id;
        }

        public ConnectionState getTargetState() {
            return this.targetState;
        }
    }
}

