/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.libs.packetevents.api.wrapper.play.client;

import com.github.kaspiandev.antipopup.libs.packetevents.api.event.PacketReceiveEvent;
import com.github.kaspiandev.antipopup.libs.packetevents.api.manager.server.ServerVersion;
import com.github.kaspiandev.antipopup.libs.packetevents.api.netty.buffer.ByteBufHelper;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.packettype.PacketType;
import com.github.kaspiandev.antipopup.libs.packetevents.api.resources.ResourceLocation;
import com.github.kaspiandev.antipopup.libs.packetevents.api.wrapper.PacketWrapper;

public class WrapperPlayClientPluginMessage
extends PacketWrapper<WrapperPlayClientPluginMessage> {
    private String channelName;
    private byte[] data;

    public WrapperPlayClientPluginMessage(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientPluginMessage(String channelName, byte[] data) {
        super(PacketType.Play.Client.PLUGIN_MESSAGE);
        this.channelName = channelName;
        this.data = data;
    }

    public WrapperPlayClientPluginMessage(ResourceLocation channelName, byte[] data) {
        super(PacketType.Play.Client.PLUGIN_MESSAGE);
        this.channelName = channelName.toString();
        this.data = data;
    }

    @Override
    public void read() {
        this.channelName = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13) ? this.readString() : this.readString(20);
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            short s = this.readShort();
        }
        if (ByteBufHelper.readableBytes(this.buffer) > Short.MAX_VALUE) {
            throw new RuntimeException("Payload may not be larger than 32767 bytes");
        }
        this.data = this.readRemainingBytes();
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            this.writeString(this.channelName);
        } else {
            this.writeString(this.channelName, 20);
        }
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            this.writeShort(this.data.length);
        }
        this.writeBytes(this.data);
    }

    @Override
    public void copy(WrapperPlayClientPluginMessage wrapper) {
        this.channelName = wrapper.channelName;
        this.data = wrapper.data;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}

