/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.libs.packetevents.api.wrapper.play.server;

import com.github.kaspiandev.antipopup.libs.packetevents.api.event.PacketSendEvent;
import com.github.kaspiandev.antipopup.libs.packetevents.api.manager.server.ServerVersion;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.packettype.PacketType;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.recipe.RecipeDisplayId;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.recipe.display.RecipeDisplay;
import com.github.kaspiandev.antipopup.libs.packetevents.api.resources.ResourceLocation;
import com.github.kaspiandev.antipopup.libs.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;

public class WrapperPlayServerCraftRecipeResponse
extends PacketWrapper<WrapperPlayServerCraftRecipeResponse> {
    private int windowId;
    @ApiStatus.Obsolete
    private RecipeDisplayId recipeId;
    @ApiStatus.Obsolete
    private ResourceLocation recipeKey;
    private RecipeDisplay<?> recipeDisplay;

    public WrapperPlayServerCraftRecipeResponse(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerCraftRecipeResponse(int windowId, int recipeId) {
        this(windowId, new RecipeDisplayId(recipeId));
    }

    public WrapperPlayServerCraftRecipeResponse(int windowId, RecipeDisplayId recipeId) {
        super(PacketType.Play.Server.CRAFT_RECIPE_RESPONSE);
        this.windowId = windowId;
        this.recipeId = recipeId;
    }

    public WrapperPlayServerCraftRecipeResponse(int windowId, String recipeKey) {
        this(windowId, new ResourceLocation(recipeKey));
    }

    public WrapperPlayServerCraftRecipeResponse(int windowId, ResourceLocation recipeKey) {
        super(PacketType.Play.Server.CRAFT_RECIPE_RESPONSE);
        this.windowId = windowId;
        this.recipeKey = recipeKey;
    }

    public WrapperPlayServerCraftRecipeResponse(int windowId, RecipeDisplay<?> recipeDisplay) {
        super(PacketType.Play.Server.CRAFT_RECIPE_RESPONSE);
        this.windowId = windowId;
        this.recipeDisplay = recipeDisplay;
    }

    @Override
    public void read() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            this.windowId = this.readContainerId();
            this.recipeDisplay = RecipeDisplay.read(this);
        } else {
            this.windowId = this.readByte();
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
                this.recipeKey = this.readIdentifier();
            } else {
                this.recipeId = RecipeDisplayId.read(this);
            }
        }
    }

    @Override
    public void write() {
        this.writeContainerId(this.windowId);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            RecipeDisplay.write(this, this.recipeDisplay);
        } else if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            this.writeIdentifier(this.recipeKey);
        } else {
            RecipeDisplayId.write(this, this.recipeId);
        }
    }

    @Override
    public void copy(WrapperPlayServerCraftRecipeResponse wrapper) {
        this.windowId = wrapper.windowId;
        this.recipeId = wrapper.recipeId;
        this.recipeKey = wrapper.recipeKey;
        this.recipeDisplay = wrapper.recipeDisplay;
    }

    public int getWindowId() {
        return this.windowId;
    }

    public void setWindowId(int windowId) {
        this.windowId = windowId;
    }

    @Deprecated
    public <T> T getRecipe() {
        return (T)(this.serverVersion.isOlderThan(ServerVersion.V_1_21_2) && this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13) ? this.recipeKey : Integer.valueOf(this.recipeId.getId()));
    }

    @Deprecated
    public <T> void setRecipe(T recipe) {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
            this.recipeKey = new ResourceLocation((String)recipe);
        } else {
            this.recipeId = new RecipeDisplayId((Integer)recipe);
        }
    }

    public ResourceLocation getRecipeKey() {
        return this.recipeKey;
    }

    public void setRecipeKey(ResourceLocation recipeKey) {
        this.recipeKey = recipeKey;
    }

    public RecipeDisplayId getRecipeId() {
        return this.recipeId;
    }

    public void setRecipeId(RecipeDisplayId recipeId) {
        this.recipeId = recipeId;
    }

    public RecipeDisplay<?> getRecipeDisplay() {
        return this.recipeDisplay;
    }

    public void setRecipeDisplay(RecipeDisplay<?> recipeDisplay) {
        this.recipeDisplay = recipeDisplay;
    }
}

