/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.libs.packetevents.api.wrapper.play.server;

import com.github.kaspiandev.antipopup.libs.kyori.adventure.text.Component;
import com.github.kaspiandev.antipopup.libs.packetevents.api.event.PacketSendEvent;
import com.github.kaspiandev.antipopup.libs.packetevents.api.manager.server.ServerVersion;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.packettype.PacketType;
import com.github.kaspiandev.antipopup.libs.packetevents.api.wrapper.PacketWrapper;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerDeathCombatEvent
extends PacketWrapper<WrapperPlayServerDeathCombatEvent> {
    private int playerId;
    private Integer entityId;
    private Component deathMessage;

    public WrapperPlayServerDeathCombatEvent(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerDeathCombatEvent(int playerId, @Nullable Integer entityId, Component deathMessage) {
        super(PacketType.Play.Server.DEATH_COMBAT_EVENT);
        this.playerId = playerId;
        this.entityId = entityId;
        this.deathMessage = deathMessage;
    }

    @Override
    public void read() {
        this.playerId = this.readVarInt();
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_19_4)) {
            this.entityId = this.readInt();
        }
        this.deathMessage = this.readComponent();
    }

    @Override
    public void write() {
        this.writeVarInt(this.playerId);
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_19_4)) {
            int id = this.entityId != null ? this.entityId : 0;
            this.writeInt(id);
        }
        this.writeComponent(this.deathMessage);
    }

    @Override
    public void copy(WrapperPlayServerDeathCombatEvent wrapper) {
        this.playerId = wrapper.playerId;
        this.entityId = wrapper.entityId;
        this.deathMessage = wrapper.deathMessage;
    }

    public int getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(int playerId) {
        this.playerId = playerId;
    }

    public Optional<Integer> getEntityId() {
        return Optional.ofNullable(this.entityId);
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public Component getDeathMessage() {
        return this.deathMessage;
    }

    public void setDeathMessage(Component deathMessage) {
        this.deathMessage = deathMessage;
    }
}

