/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.libs.packetevents.velocity.velocity.factory;

import com.github.kaspiandev.antipopup.libs.kyori.adventure.text.format.NamedTextColor;
import com.github.kaspiandev.antipopup.libs.packetevents.api.PacketEvents;
import com.github.kaspiandev.antipopup.libs.packetevents.api.PacketEventsAPI;
import com.github.kaspiandev.antipopup.libs.packetevents.api.event.UserLoginEvent;
import com.github.kaspiandev.antipopup.libs.packetevents.api.injector.ChannelInjector;
import com.github.kaspiandev.antipopup.libs.packetevents.api.manager.InternalPacketListener;
import com.github.kaspiandev.antipopup.libs.packetevents.api.manager.player.PlayerManager;
import com.github.kaspiandev.antipopup.libs.packetevents.api.manager.protocol.ProtocolManager;
import com.github.kaspiandev.antipopup.libs.packetevents.api.manager.server.ServerManager;
import com.github.kaspiandev.antipopup.libs.packetevents.api.manager.server.ServerVersion;
import com.github.kaspiandev.antipopup.libs.packetevents.api.netty.NettyManager;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.ProtocolVersion;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.packettype.PacketType;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.player.ClientVersion;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.player.User;
import com.github.kaspiandev.antipopup.libs.packetevents.api.protocol.world.states.WrappedBlockState;
import com.github.kaspiandev.antipopup.libs.packetevents.api.settings.PacketEventsSettings;
import com.github.kaspiandev.antipopup.libs.packetevents.api.util.LogManager;
import com.github.kaspiandev.antipopup.libs.packetevents.velocity.impl.netty.NettyManagerImpl;
import com.github.kaspiandev.antipopup.libs.packetevents.velocity.impl.netty.manager.player.PlayerManagerAbstract;
import com.github.kaspiandev.antipopup.libs.packetevents.velocity.impl.netty.manager.protocol.ProtocolManagerAbstract;
import com.github.kaspiandev.antipopup.libs.packetevents.velocity.impl.netty.manager.server.ServerManagerAbstract;
import com.github.kaspiandev.antipopup.libs.packetevents.velocity.injector.VelocityPipelineInjector;
import com.github.kaspiandev.antipopup.libs.packetevents.velocity.manager.PlayerManagerImpl;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Level;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class VelocityPacketEventsBuilder {
    private static PacketEventsAPI<PluginContainer> INSTANCE;

    public static void clearBuildCache() {
        INSTANCE = null;
    }

    public static PacketEventsAPI<PluginContainer> build(ProxyServer server, PluginContainer plugin, Logger logger, Path dataDirectory) {
        if (INSTANCE == null) {
            INSTANCE = VelocityPacketEventsBuilder.buildNoCache(server, plugin, logger, dataDirectory);
        }
        return INSTANCE;
    }

    public static PacketEventsAPI<PluginContainer> build(ProxyServer server, PluginContainer plugin, Logger logger, Path dataDirectory, PacketEventsSettings settings) {
        if (INSTANCE == null) {
            INSTANCE = VelocityPacketEventsBuilder.buildNoCache(server, plugin, logger, dataDirectory, settings);
        }
        return INSTANCE;
    }

    public static PacketEventsAPI<PluginContainer> buildNoCache(ProxyServer server, PluginContainer plugin, Logger logger, Path dataDirectory) {
        return VelocityPacketEventsBuilder.buildNoCache(server, plugin, logger, dataDirectory, new PacketEventsSettings());
    }

    public static PacketEventsAPI<PluginContainer> buildNoCache(final ProxyServer server, final PluginContainer plugin, Logger logger, Path dataDirectory, final PacketEventsSettings inSettings) {
        return new PacketEventsAPI<PluginContainer>(){
            private final PacketEventsSettings settings;
            private final ProtocolManager protocolManager;
            private final ServerManager serverManager;
            private final PlayerManagerAbstract playerManager;
            private final ChannelInjector injector;
            private final NettyManager nettyManager;
            private final LogManager logManager;
            private boolean loaded;
            private boolean initialized;
            private boolean terminated;
            {
                this.settings = inSettings;
                this.protocolManager = new ProtocolManagerAbstract(){

                    @Override
                    public ProtocolVersion getPlatformVersion() {
                        return ProtocolVersion.UNKNOWN;
                    }
                };
                this.serverManager = new ServerManagerAbstract(){
                    private final Field connectionInFlight;
                    private final Field registeredServer;
                    private ServerVersion version;
                    {
                        try {
                            Class<?> playerClass = Class.forName("com.velocitypowered.proxy.connection.client.ConnectedPlayer");
                            this.connectionInFlight = playerClass.getDeclaredField("connectionInFlight");
                            this.connectionInFlight.setAccessible(true);
                            Class<?> serverConnectionClass = Class.forName("com.velocitypowered.proxy.connection.backend.VelocityServerConnection");
                            this.registeredServer = serverConnectionClass.getDeclaredField("registeredServer");
                            this.registeredServer.setAccessible(true);
                        }
                        catch (ReflectiveOperationException exception) {
                            throw new RuntimeException("Error while resolving methods for getting player server connection");
                        }
                    }

                    @Override
                    public ServerVersion getVersion() {
                        if (this.version == null) {
                            com.velocitypowered.api.network.ProtocolVersion[] velVers = com.velocitypowered.api.network.ProtocolVersion.values();
                            for (int i = velVers.length - 1; i >= 0; --i) {
                                com.velocitypowered.api.network.ProtocolVersion velVer = velVers[i];
                                if (velVer.isLegacy() || velVer.isUnknown()) continue;
                                String velVerStr = velVer.getVersionIntroducedIn();
                                for (ServerVersion peVer : ServerVersion.values()) {
                                    if (!peVer.getReleaseName().contains(velVerStr)) continue;
                                    this.version = peVer;
                                    return peVer;
                                }
                            }
                            throw new IllegalStateException("Can't find any version compatible with this velocity instance");
                        }
                        return this.version;
                    }

                    @Nullable
                    private Object getTargetServer(Player player) {
                        ServerConnection server = player.getCurrentServer().orElse(null);
                        if (server != null) {
                            return server;
                        }
                        try {
                            Object connection = this.connectionInFlight.get(player);
                            return connection != null ? this.registeredServer.get(connection) : null;
                        }
                        catch (IllegalAccessException exception) {
                            throw new RuntimeException(exception);
                        }
                    }

                    @Override
                    public Object getRegistryCacheKey(User user, ClientVersion version) {
                        Player player = server.getPlayer(user.getUUID()).orElse(null);
                        return player == null ? null : Integer.valueOf(Objects.hash(new Object[]{this.getTargetServer(player), version}));
                    }
                };
                this.playerManager = new PlayerManagerImpl();
                this.injector = new VelocityPipelineInjector(server);
                this.nettyManager = new NettyManagerImpl();
                this.logManager = new LogManager(){

                    @Override
                    protected void log(Level level, @Nullable NamedTextColor color, String message) {
                        System.out.println(message);
                    }
                };
            }

            @Override
            public void load() {
                if (!this.loaded) {
                    String id = plugin.getDescription().getId();
                    PacketEvents.IDENTIFIER = "pe-" + id;
                    PacketEvents.ENCODER_NAME = "pe-encoder-" + id;
                    PacketEvents.DECODER_NAME = "pe-decoder-" + id;
                    PacketEvents.CONNECTION_HANDLER_NAME = "pe-connection-handler-" + id;
                    PacketEvents.SERVER_CHANNEL_HANDLER_NAME = "pe-connection-initializer-" + id;
                    PacketEvents.TIMEOUT_HANDLER_NAME = "pe-timeout-handler-" + id;
                    WrappedBlockState.ensureLoad();
                    this.injector.inject();
                    this.loaded = true;
                    this.getEventManager().registerListener(new InternalPacketListener());
                }
            }

            @Override
            public boolean isLoaded() {
                return this.loaded;
            }

            @Override
            public void init() {
                this.load();
                if (this.initialized) {
                    return;
                }
                server.getEventManager().register(plugin.getInstance().orElse(null), PostLoginEvent.class, event -> {
                    Player player = event.getPlayer();
                    Object channel = PacketEvents.getAPI().getPlayerManager().getChannel(player);
                    if (channel == null) {
                        return;
                    }
                    PacketEvents.getAPI().getInjector().setPlayer(channel, player);
                    User user = PacketEvents.getAPI().getPlayerManager().getUser(player);
                    if (user == null) {
                        return;
                    }
                    UserLoginEvent loginEvent = new UserLoginEvent(user, player);
                    PacketEvents.getAPI().getEventManager().callEvent(loginEvent);
                });
                if (this.settings.shouldCheckForUpdates()) {
                    this.getUpdateChecker().handleUpdateCheck();
                }
                PacketType.Play.Client.load();
                PacketType.Play.Server.load();
                this.initialized = true;
            }

            @Override
            public boolean isInitialized() {
                return this.initialized;
            }

            @Override
            public void terminate() {
                if (this.initialized) {
                    this.injector.uninject();
                    this.getEventManager().unregisterAllListeners();
                    this.initialized = false;
                    this.terminated = true;
                }
            }

            @Override
            public boolean isTerminated() {
                return this.terminated;
            }

            @Override
            public LogManager getLogManager() {
                return this.logManager;
            }

            @Override
            public PluginContainer getPlugin() {
                return plugin;
            }

            @Override
            public ProtocolManager getProtocolManager() {
                return this.protocolManager;
            }

            @Override
            public ServerManager getServerManager() {
                return this.serverManager;
            }

            @Override
            public PlayerManager getPlayerManager() {
                return this.playerManager;
            }

            @Override
            public ChannelInjector getInjector() {
                return this.injector;
            }

            @Override
            public PacketEventsSettings getSettings() {
                return this.settings;
            }

            @Override
            public NettyManager getNettyManager() {
                return this.nettyManager;
            }
        };
    }
}

