/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.spigot;

import com.github.kaspiandev.antipopup.config.APConfig;
import com.github.kaspiandev.antipopup.libs.bstats.bukkit.Metrics;
import com.github.kaspiandev.antipopup.libs.bstats.charts.SimplePie;
import com.github.kaspiandev.antipopup.libs.folialib.FoliaLib;
import com.github.kaspiandev.antipopup.libs.packetevents.api.PacketEvents;
import com.github.kaspiandev.antipopup.libs.packetevents.api.event.PacketListenerPriority;
import com.github.kaspiandev.antipopup.libs.packetevents.api.manager.server.ServerManager;
import com.github.kaspiandev.antipopup.libs.packetevents.api.manager.server.ServerVersion;
import com.github.kaspiandev.antipopup.libs.packetevents.spigot.factory.spigot.SpigotPacketEventsBuilder;
import com.github.kaspiandev.antipopup.listener.PacketEventsListener;
import com.github.kaspiandev.antipopup.log.LogFilter;
import com.github.kaspiandev.antipopup.message.ConsoleMessages;
import com.github.kaspiandev.antipopup.nms.v1_19_2.PlayerInjector_v1_19_2;
import com.github.kaspiandev.antipopup.nms.v1_19_3.PlayerInjector_v1_19_3;
import com.github.kaspiandev.antipopup.nms.v1_19_4.PlayerInjector_v1_19_4;
import com.github.kaspiandev.antipopup.nms.v1_20_1.PlayerInjector_v1_20_1;
import com.github.kaspiandev.antipopup.nms.v1_20_2.PlayerInjector_v1_20_2;
import com.github.kaspiandev.antipopup.nms.v1_20_4.PlayerInjector_v1_20_4;
import com.github.kaspiandev.antipopup.nms.v1_20_6.PlayerInjector_v1_20_6;
import com.github.kaspiandev.antipopup.nms.v1_21.PlayerInjector_v1_21;
import com.github.kaspiandev.antipopup.nms.v1_21_2.PlayerInjector_v1_21_2;
import com.github.kaspiandev.antipopup.nms.v1_21_4.PlayerInjector_v1_21_4;
import com.github.kaspiandev.antipopup.nms.v1_21_5.PlayerInjector_v1_21_5;
import com.github.kaspiandev.antipopup.nms.v1_21_6.PlayerInjector_v1_21_6;
import com.github.kaspiandev.antipopup.nms.v1_21_9.PlayerInjector_v1_21_9;
import com.github.kaspiandev.antipopup.spigot.CommandRegister;
import com.github.kaspiandev.antipopup.spigot.api.Api;
import com.github.kaspiandev.antipopup.spigot.hook.HookManager;
import com.github.kaspiandev.antipopup.spigot.hook.viaversion.ViaVersionHook;
import com.github.kaspiandev.antipopup.spigot.hook.viaversion.Via_1_19_to_1_19_1;
import com.github.kaspiandev.antipopup.spigot.hook.viaversion.Via_1_20_4_to_1_20_5;
import com.github.kaspiandev.antipopup.spigot.listeners.ChatListener;
import com.github.kaspiandev.antipopup.spigot.nms.PlayerListener;
import com.github.kaspiandev.antipopup.spigot.platform.SpigotPlatform;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class AntiPopup
extends JavaPlugin {
    private static AntiPopup instance;
    private static File propertiesFile;
    private static APConfig config;
    private static FoliaLib foliaLib;

    public static FoliaLib getFoliaLib() {
        return foliaLib;
    }

    public static File getPropertiesFile() {
        return propertiesFile;
    }

    public static AntiPopup getInstance() {
        return instance;
    }

    public void onLoad() {
        instance = this;
        PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().getSettings().debug(false).checkForUpdates(false);
        PacketEvents.getAPI().load();
        this.getLogger().info("Loaded PacketEvents.");
    }

    public void onEnable() {
        foliaLib = new FoliaLib(this);
        try {
            config = new APConfig(this.getDataFolder(), this.getClassLoader());
            this.getLogger().info("Config enabled.");
        }
        catch (IOException ex) {
            this.getLogger().warning("Config file could not be initialized.");
            throw new RuntimeException(ex);
        }
        SpigotPlatform spigotPlatform = new SpigotPlatform(config);
        propertiesFile = new File(Bukkit.getWorldContainer().getParentFile(), config.getPropertiesLocation());
        if (config.isBstats()) {
            Metrics metrics = new Metrics(this, 16308);
            metrics.addCustomChart(new SimplePie("runs_viaversion", () -> Bukkit.getPluginManager().isPluginEnabled("ViaVersion") ? "Yes" : "No"));
            this.getLogger().info("Loaded optional metrics.");
        }
        ServerManager serverManager = PacketEvents.getAPI().getServerManager();
        PluginManager pluginManager = Bukkit.getPluginManager();
        HookManager hookManager = new HookManager();
        ViaVersionHook viaVersionHook = new ViaVersionHook();
        viaVersionHook.addModifier(Via_1_19_to_1_19_1.class);
        viaVersionHook.addModifier(Via_1_20_4_to_1_20_5.class);
        hookManager.addHook(viaVersionHook);
        hookManager.load();
        if (config.isClickableUrls()) {
            this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(), (Plugin)this);
            this.getLogger().info("Enabled URL support.");
        }
        PacketEvents.getAPI().getEventManager().registerListener(new PacketEventsListener(spigotPlatform), PacketListenerPriority.LOW);
        PacketEvents.getAPI().init();
        this.getLogger().info("Initiated PacketEvents.");
        if (config.isBlockChatReports() && serverManager.getVersion().isOlderThan(ServerVersion.V_1_19_1)) {
            config.setBlockChatReports(false);
            ConsoleMessages.log(ConsoleMessages.BLOCKING_REPORTS_UNSUPPORTED, this.getLogger()::severe);
            throw new IllegalStateException("Blocking chat reports was enabled but your server version isn't supported!");
        }
        if (config.isBlockChatReports()) {
            if (!config.isExperimentalMode()) {
                PlayerListener playerListener = switch (serverManager.getVersion()) {
                    case ServerVersion.V_1_21_9, ServerVersion.V_1_21_10 -> new PlayerListener(new PlayerInjector_v1_21_9());
                    case ServerVersion.V_1_21_6, ServerVersion.V_1_21_7, ServerVersion.V_1_21_8 -> new PlayerListener(new PlayerInjector_v1_21_6());
                    case ServerVersion.V_1_21_5 -> new PlayerListener(new PlayerInjector_v1_21_5());
                    case ServerVersion.V_1_21_4 -> new PlayerListener(new PlayerInjector_v1_21_4());
                    case ServerVersion.V_1_21_2, ServerVersion.V_1_21_3 -> new PlayerListener(new PlayerInjector_v1_21_2());
                    case ServerVersion.V_1_21, ServerVersion.V_1_21_1 -> new PlayerListener(new PlayerInjector_v1_21());
                    case ServerVersion.V_1_20_5, ServerVersion.V_1_20_6 -> new PlayerListener(new PlayerInjector_v1_20_6());
                    case ServerVersion.V_1_20_3, ServerVersion.V_1_20_4 -> new PlayerListener(new PlayerInjector_v1_20_4());
                    case ServerVersion.V_1_20_2 -> new PlayerListener(new PlayerInjector_v1_20_2());
                    case ServerVersion.V_1_20, ServerVersion.V_1_20_1 -> new PlayerListener(new PlayerInjector_v1_20_1());
                    case ServerVersion.V_1_19_4 -> new PlayerListener(new PlayerInjector_v1_19_4());
                    case ServerVersion.V_1_19_3 -> new PlayerListener(new PlayerInjector_v1_19_3());
                    case ServerVersion.V_1_19_1, ServerVersion.V_1_19_2 -> new PlayerListener(new PlayerInjector_v1_19_2());
                    default -> throw new IllegalStateException("No valid injector found for the server version!");
                };
                pluginManager.registerEvents((Listener)playerListener, (Plugin)this);
                this.getLogger().info("Hooked on " + serverManager.getVersion().getReleaseName());
            } else {
                this.getLogger().info("Experimental mode is on");
            }
        }
        Objects.requireNonNull(this.getCommand("antipopup")).setExecutor((CommandExecutor)new CommandRegister(config));
        this.getLogger().info("Commands registered.");
        if (config.isFilterNotSecure()) {
            ((Logger)LogManager.getRootLogger()).addFilter((Filter)new LogFilter());
            this.getLogger().info("Logger filter enabled.");
        }
        foliaLib.getImpl().runLater(() -> {
            if (config.isAutoSetup()) {
                Api.setupAntiPopup(80, true);
            }
            if (config.isFirstRun()) {
                try {
                    FileInputStream in = new FileInputStream(propertiesFile);
                    Properties props = new Properties();
                    props.load(in);
                    if (Boolean.parseBoolean(props.getProperty("enforce-secure-profile"))) {
                        ConsoleMessages.log(ConsoleMessages.ASK_SETUP, this.getLogger()::warning);
                    }
                    in.close();
                    config.setFirstRun(false);
                    config.save();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (config.isAskBstats()) {
                ConsoleMessages.log(ConsoleMessages.ASK_BSTATS, this.getLogger()::warning);
                config.setAskBstats(false);
                config.save();
            }
        }, 250L, TimeUnit.MILLISECONDS);
    }

    public void onDisable() {
        PacketEvents.getAPI().terminate();
        this.getLogger().info("Disabled PacketEvents.");
    }
}

