/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.spigot.hook.viaversion;

import com.github.kaspiandev.antipopup.libs.packetevents.api.PacketEvents;
import com.github.kaspiandev.antipopup.libs.packetevents.api.manager.server.ServerVersion;
import com.github.kaspiandev.antipopup.libs.packetevents.api.manager.server.VersionComparison;
import com.github.kaspiandev.antipopup.spigot.AntiPopup;
import com.github.kaspiandev.antipopup.spigot.hook.Hook;
import com.github.kaspiandev.antipopup.spigot.hook.viaversion.ViaProtocolModifier;
import com.viaversion.viaversion.api.Via;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ViaVersionHook
implements Hook {
    private final List<Class<? extends ViaProtocolModifier<?>>> modifiers = new ArrayList();
    private final List<ViaProtocolModifier<?>> registeredModifiers = new ArrayList();

    public void addModifier(Class<? extends ViaProtocolModifier<?>> modifier) {
        this.modifiers.add(modifier);
    }

    @Override
    public String getPluginName() {
        return "ViaVersion";
    }

    @Override
    public void register() {
        if (Via.getAPI().getVersion().startsWith("4")) {
            throw new IllegalStateException("ViaVersion 4 is not supported anymore. Update to ViaVersion 5 for hooks to work!");
        }
        ServerVersion serverVersion = PacketEvents.getAPI().getServerManager().getVersion();
        Iterator<Class<ViaProtocolModifier<?>>> iterator = this.modifiers.iterator();
        while (iterator.hasNext()) {
            try {
                Class<ViaProtocolModifier<?>> modifier = iterator.next();
                ViaProtocolModifier<?> modifierInstance = modifier.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!serverVersion.is(modifierInstance.getComparison(), modifierInstance.getVersion())) continue;
                modifierInstance.modify();
                this.registeredModifiers.add(modifierInstance);
                AntiPopup.getInstance().getLogger().info(() -> this.getRegisteredMessage(modifierInstance));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
        }
    }

    private String getRegisteredMessage(ViaProtocolModifier<?> modifier) {
        String comparison = switch (modifier.getComparison()) {
            default -> throw new IncompatibleClassChangeError();
            case VersionComparison.EQUALS -> "equal to";
            case VersionComparison.OLDER_THAN -> "older than";
            case VersionComparison.NEWER_THAN -> "newer than";
            case VersionComparison.NEWER_THAN_OR_EQUALS -> "newer than or equal to";
            case VersionComparison.OLDER_THAN_OR_EQUALS -> "older than or equal to";
        };
        return "Registered a modifier targeted for versions " + comparison + " " + modifier.getVersion().getReleaseName() + ".";
    }

    public List<ViaProtocolModifier<?>> getRegisteredModifiers() {
        return this.registeredModifiers;
    }
}

