/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaspiandev.antipopup.velocity;

import com.github.kaspiandev.antipopup.config.APConfig;
import com.github.kaspiandev.antipopup.libs.packetevents.api.PacketEvents;
import com.github.kaspiandev.antipopup.libs.packetevents.api.event.PacketListenerPriority;
import com.github.kaspiandev.antipopup.libs.packetevents.velocity.velocity.factory.VelocityPacketEventsBuilder;
import com.github.kaspiandev.antipopup.listener.PacketEventsListener;
import com.github.kaspiandev.antipopup.velocity.platform.VelocityPlatform;
import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.IOException;
import java.nio.file.Path;
import org.slf4j.Logger;

@Plugin(id="antipopup", name="AntiPopup", authors={"KaspianDev"}, version="12.3")
public class AntiPopup {
    private final ProxyServer server;
    private final APConfig config;
    private final Logger logger;
    private final Path dataDirectory;

    @Inject
    public AntiPopup(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) throws IOException {
        this.server = server;
        this.logger = logger;
        this.config = new APConfig(dataDirectory.toFile(), this.getClass().getClassLoader());
        this.dataDirectory = dataDirectory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        VelocityPlatform platform = new VelocityPlatform(this.server, this.config);
        PluginContainer pluginContainer = this.server.getPluginManager().ensurePluginContainer((Object)this);
        PacketEvents.setAPI(VelocityPacketEventsBuilder.build(this.server, pluginContainer, this.logger, this.dataDirectory));
        PacketEvents.getAPI().getSettings().debug(false).checkForUpdates(false);
        PacketEvents.getAPI().load();
        PacketEvents.getAPI().getEventManager().registerListener(new PacketEventsListener(platform), PacketListenerPriority.LOW);
        PacketEvents.getAPI().init();
    }
}

