/*
 * Decompiled with CFR 0.152.
 */
package afd.webrequests;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRequests
implements ModInitializer {
    public static final String MOD_ID = "web-requests";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"web-requests");

    public void onInitialize() {
        HttpClient httpClient = HttpClient.newHttpClient();
        LOGGER.info("Loaded Web Requests Mod");
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"request").then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"URL", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"headers", (ArgumentType)StringArgumentType.string()).executes(WebRequests::getRequest))))).then(class_2170.method_9247((String)"post").then(class_2170.method_9244((String)"URL", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"headers", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"body", (ArgumentType)StringArgumentType.string()).executes(WebRequests::postRequest)))))));
    }

    public static int postRequest(CommandContext<class_2168> context) {
        String url = StringArgumentType.getString(context, (String)"URL");
        String headers = StringArgumentType.getString(context, (String)"headers");
        String body = StringArgumentType.getString(context, (String)"body");
        try {
            String[] header_list;
            HttpRequest.Builder builder = HttpRequest.newBuilder().setHeader("User-Agent", "Minecraft Fabric Web Requests mod by AFancyDog [https://github.com/AFancyDog/Web-Requests]").POST(HttpRequest.BodyPublishers.ofString(body)).uri(new URI(url));
            for (String s : header_list = headers.split(":::")) {
                String[] kv = s.split(":", 2);
                builder.header(kv[0], kv[1]);
            }
            HttpRequest request = builder.build();
            HttpResponse<String> response = HttpClient.newBuilder().build().send(request, HttpResponse.BodyHandlers.ofString());
            LOGGER.info("Response is %s".formatted(response.statusCode()));
            return response.statusCode();
        }
        catch (Exception error) {
            LOGGER.error("Get request failed with exception: %s".formatted(error));
            return 1;
        }
    }

    public static int getRequest(CommandContext<class_2168> context) {
        String url = StringArgumentType.getString(context, (String)"URL");
        String headers = StringArgumentType.getString(context, (String)"headers");
        try {
            String[] header_list;
            HttpRequest.Builder builder = HttpRequest.newBuilder().setHeader("User-Agent", "Minecraft Fabric Web Requests mod by AFancyDog [https://github.com/AFancyDog/Web-Requests]").GET().uri(new URI(url));
            for (String s : header_list = headers.split(":::")) {
                String[] kv = s.split(":", 2);
                builder.header(kv[0], kv[1]);
            }
            HttpRequest request = builder.build();
            HttpResponse<String> response = HttpClient.newBuilder().build().send(request, HttpResponse.BodyHandlers.ofString());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Sent a get request to %s".formatted(url)), false);
            LOGGER.info("Response from %s".formatted(url) + "is %s".formatted(response.statusCode()));
            return response.statusCode();
        }
        catch (Exception error) {
            LOGGER.error("Get request failed with exception: %s".formatted(error));
            return 1;
        }
    }
}

