/*
 * Decompiled with CFR 0.152.
 */
package com.fletime.nointernet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigManager.class);
    private static final String CONFIG_FILE = "nointernet.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static List<String> whitelist = new ArrayList<String>();
    private static boolean configLoaded = false;
    private static boolean configValid = false;
    private static boolean logBlockedRequests = true;

    public static void loadConfig() {
        try {
            JsonObject config;
            Path configDir = Paths.get("config", new String[0]);
            Path configFile = configDir.resolve(CONFIG_FILE);
            if (!Files.exists(configFile, new LinkOption[0])) {
                ConfigManager.createDefaultConfig(configDir, configFile);
            }
            if ((config = (JsonObject)GSON.fromJson((Reader)Files.newBufferedReader(configFile), JsonObject.class)).has("whitelist")) {
                whitelist.clear();
                config.getAsJsonArray("whitelist").forEach(element -> whitelist.add(element.getAsString()));
                LOGGER.info("[NoInternet] \u6210\u529f\u52a0\u8f7d\u767d\u540d\u5355\u914d\u7f6e\uff0c\u5305\u542b " + whitelist.size() + " \u4e2a\u57df\u540d");
                configValid = true;
                logBlockedRequests = config.has("logBlockedRequests") ? config.get("logBlockedRequests").getAsBoolean() : true;
            } else {
                configValid = false;
            }
            configLoaded = true;
        }
        catch (Exception e) {
            LOGGER.error("[NoInternet] \u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            configValid = false;
            configLoaded = true;
        }
    }

    private static void createDefaultConfig(Path configDir, Path configFile) throws IOException {
        if (!Files.exists(configDir, new LinkOption[0])) {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        JsonObject defaultConfig = new JsonObject();
        ArrayList<String> defaultWhitelist = new ArrayList<String>();
        defaultWhitelist.add("$emojang.com");
        defaultWhitelist.add("$eminecraft.net");
        defaultWhitelist.add("$ctoriifind.json");
        defaultWhitelist.add("$clynn.json");
        defaultConfig.add("whitelist", GSON.toJsonTree(defaultWhitelist));
        defaultConfig.addProperty("logBlockedRequests", Boolean.valueOf(true));
        try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
            GSON.toJson((JsonElement)defaultConfig, (Appendable)writer);
        }
    }

    public static boolean isWhitelisted(URI uri) {
        if (!configLoaded) {
            ConfigManager.loadConfig();
        }
        if (!configValid) {
            return true;
        }
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        Object fullAddress = host;
        if (uri.getPort() > 0) {
            fullAddress = (String)fullAddress + ":" + uri.getPort();
        }
        if (uri.getPath() != null) {
            fullAddress = (String)fullAddress + uri.getPath();
        }
        if (uri.getQuery() != null) {
            fullAddress = (String)fullAddress + "?" + uri.getQuery();
        }
        for (String whitelistedDomain : whitelist) {
            if (!ConfigManager.matchesPattern(host, (String)fullAddress, whitelistedDomain)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesPattern(String host, String fullAddress, String pattern) {
        if (pattern.startsWith("$r")) {
            try {
                String regex = pattern.substring(2);
                return Pattern.matches(regex, host) || Pattern.matches(regex, fullAddress);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (pattern.startsWith("$e")) {
            String suffix = pattern.substring(2);
            return host.endsWith(suffix) || fullAddress.endsWith(suffix);
        }
        if (pattern.startsWith("$s")) {
            String prefix = pattern.substring(2);
            return host.startsWith(prefix) || fullAddress.startsWith(prefix);
        }
        if (pattern.startsWith("$c")) {
            String substring = pattern.substring(2);
            return host.contains(substring) || fullAddress.contains(substring);
        }
        return host.equals(pattern) || fullAddress.equals(pattern);
    }

    public static List<String> getWhitelist() {
        if (!configLoaded) {
            ConfigManager.loadConfig();
        }
        return new ArrayList<String>(whitelist);
    }

    public static boolean isConfigValid() {
        if (!configLoaded) {
            ConfigManager.loadConfig();
        }
        return configValid;
    }

    public static boolean shouldLogBlockedRequests() {
        if (!configLoaded) {
            ConfigManager.loadConfig();
        }
        return logBlockedRequests;
    }
}

