/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.core.util;

import com.dolthhaven.dolt_mod_how.core.DoltModHow;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DMHUtils {
    public static final int NOT_TOOLBOX = 0;
    public static final int SUCCESSFUL_SETTING = 1;
    public static final int UNSUCCESSFUL_SETTING = 2;

    public static void printItem(Item item) {
        ResourceLocation res = ForgeRegistries.ITEMS.getKey((Object)item);
        if (res == ForgeRegistries.ITEMS.getDefaultKey() || res == null) {
            DoltModHow.LOGGER.info("DoltModHow.Util.printItem used, but no Item was found!!");
        } else {
            DoltModHow.LOGGER.info(res.toString());
        }
    }

    @Nullable
    public static Item getPotentialItem(ResourceLocation loc) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(loc);
        if (item == Items.f_41852_) {
            return null;
        }
        return item;
    }

    @Nullable
    public static Item getPotentialItem(String path, String name) {
        return DMHUtils.getPotentialItem(new ResourceLocation(path, name));
    }

    @Nullable
    public static Block getPotentialBlock(ResourceLocation loc) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(loc);
        return block == Blocks.f_50016_ ? null : block;
    }

    @Nullable
    public static Block getPotentialBlock(String path, String name) {
        return DMHUtils.getPotentialBlock(new ResourceLocation(path, name));
    }

    @NotNull
    public static Fluid getFluidOrWater(String path, String name) {
        return DMHUtils.getFluidOrWater(new ResourceLocation(path, name));
    }

    @NotNull
    public static Fluid getFluidOrWater(ResourceLocation location) {
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(location);
        return fluid != null ? fluid : Fluids.f_76193_;
    }

    public static ResourceLocation getFluidID(Fluid fluid) {
        return ForgeRegistries.FLUIDS.getKey((Object)fluid);
    }

    public static ResourceLocation getItemId(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static ResourceLocation getBlockId(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public static boolean alexCavesLoaded() {
        return ModList.get().isLoaded("alexscaves");
    }

    public static class Constants {
        public static final String ALEXS_CAVES = "alexscaves";
        public static final String ATMOSPHERIC = "atmospheric";
        public static final String BOP = "biomesoplenty";
        public static final String BLASTED_BARRENS = "blasted_barrens";
        public static final String BREWING_AND_CHEWING = "brewinandchewin";
        public static final String CAVERNS_AND_CHASMS = "caverns_and_chasms";
        public static final String CAVE_DELIGHT = "cavedelight";
        public static final String CLAYWORKS = "clayworks";
        public static final String CREATE = "create";
        public static final String DUNGEONS_DELIGHT = "dungeonsdelight";
        public static final String DYE_DEPOT = "dye_depot";
        public static final String ENVIRONMENTAL = "environmental";
        public static final String FARMERS_DELIGHT = "farmersdelight";
        public static final String MOWZIES_MOBS = "mowziesmobs";
        public static final String MY_NETHERS_DELIGHT = "mynethersdelight";
        public static final String NEAPOLITAN = "neapolitan";
        public static final String JNE = "netherexp";
        public static final String OREGANIZED = "oreganized";
        public static final String QUARK = "quark";
        public static final String UPGRADE_AQUATIC = "upgrade_aquatic";
        public static final String SPECIES = "species";
        public static final String WOODWORKS = "woodworks";
        public static final ResourceLocation ALPHACENE_GRASS_BLOCK = new ResourceLocation("species", "alphacene_grass_block");
        public static final ResourceLocation STURDY_STONE = new ResourceLocation("quark", "sturdy_stone");
        public static final ResourceLocation BULLET_PEPPER = new ResourceLocation("mynethersdelight", "bullet_pepper");
        public static final ResourceLocation CONCRETE = new ResourceLocation("clayworks", "concrete");
        public static final ResourceLocation CONCRETE_POWDER = new ResourceLocation("clayworks", "concrete_powder");
        public static final ResourceLocation GOLDEN_LAVA_BUCKET = new ResourceLocation("caverns_and_chasms", "golden_lava_bucket");
        public static final ResourceLocation STRAWBERRY_PIPS = new ResourceLocation("neapolitan", "strawberry_pips");
        public static final ResourceLocation BANANA_PEEL = new ResourceLocation("neapolitan", "banana_peel");
        public static final ResourceLocation SAND_RAKE = new ResourceLocation("mowziesmobs", "sand_rake");
        public static final ResourceLocation RAKED_SAND = new ResourceLocation("mowziesmobs", "raked_sand");
        public static final ResourceLocation RED_RAKED_SAND = new ResourceLocation("mowziesmobs", "red_raked_sand");
        public static final ResourceLocation ARID_SAND = new ResourceLocation("atmospheric", "arid_sand");
        public static final ResourceLocation RED_ARID_SAND = new ResourceLocation("atmospheric", "red_arid_sand");
        public static final ResourceLocation ASHEN_SAND = new ResourceLocation("blasted_barrens", "ashen_sand");
        public static final ResourceLocation ACID = new ResourceLocation("alexscaves", "acid");
        public static final ResourceLocation PURPLE_SODA = new ResourceLocation("alexscaves", "purple_soda");
        public static final ResourceLocation MOLTEN_LEAD = new ResourceLocation("oreganized", "molten_lead");
        public static final ResourceLocation DESOLATE_DAGGER = new ResourceLocation("alexscaves", "desolate_dagger");
        public static final ResourceLocation DINOSAUR_CHOP = new ResourceLocation("alexscaves", "dinosaur_chop");
        public static final ResourceLocation COOKED_DINOSAUR_CHOPS = new ResourceLocation("alexscaves", "cooked_dinosaur_chop");
        public static final ResourceLocation ZINC_BLOCK = new ResourceLocation("create", "zinc_block");
        public static final ResourceLocation MOWZIES_MOBS_TAB = new ResourceLocation("mowziesmobs", "mowziesmobs_tab");
        public static final ResourceLocation CREATE_BUILDING_TAB = new ResourceLocation("create", "palettes");
        public static final ResourceLocation DUNGEONS_DELIGHT_TAB = new ResourceLocation("dungeonsdelight", "dungeonsdelight_tab");
        public static final ResourceLocation WARDENZOLA = new ResourceLocation("dungeonsdelight", "wardenzola");
        public static final ResourceLocation PATHFINDER_QUILL = new ResourceLocation("quark", "pathfinder_quill");
        public static final ResourceLocation ALPHACENE_MOSS_CARPET = new ResourceLocation("species", "alphacene_moss_carpet");

        public static boolean runData() {
            for (String str : new String[]{ALEXS_CAVES, ATMOSPHERIC, BLASTED_BARRENS, NEAPOLITAN, UPGRADE_AQUATIC, ENVIRONMENTAL, MOWZIES_MOBS, WOODWORKS, BREWING_AND_CHEWING}) {
                if (ModList.get().isLoaded(str)) continue;
                return false;
            }
            return true;
        }
    }
}

