/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.integration;

import com.dolthhaven.dolt_mod_how.core.util.DMHUtils;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;

public class DyeDepotCompat {
    private static final Pattern DYE_PATTERN = Pattern.compile("([a-z]+)_dye$");

    public static String getDyeDepotDyeColor(Item item) {
        Matcher matcher;
        ResourceLocation loc = DMHUtils.getItemId(item);
        if (loc.m_135827_().equals("dye_depot") && (matcher = DYE_PATTERN.matcher(loc.m_135815_())).matches()) {
            String dye = matcher.group(1);
            return DyeDepotCompat.getDyeDepotDye(dye);
        }
        return null;
    }

    public static String getDyeDepotDye(String dye) {
        try {
            DyeDepotDyes.valueOf(dye.toUpperCase(Locale.ROOT));
            return dye;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String getVanillaDye(String dye) {
        try {
            VanillaDyes.valueOf(dye.toUpperCase(Locale.ROOT));
            return dye;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String getAny(String dye) {
        if (DyeDepotCompat.getVanillaDye(dye) == null && DyeDepotCompat.getDyeDepotDye(dye) == null) {
            return null;
        }
        return dye;
    }

    public static enum DyeDepotDyes implements StringRepresentable
    {
        ROSE("rose"),
        MAROON("maroon"),
        GINGER("ginger"),
        TAN("tan"),
        BEIGE("beige"),
        CORAL("coral"),
        OLIVE("olive"),
        FOREST("forest"),
        VERDANT("verdant"),
        AMBER("amber"),
        TEAL("teal"),
        MINT("mint"),
        AQUA("aqua"),
        SLATE("slate"),
        NAVY("navy"),
        INDIGO("indigo");

        final String name;

        private DyeDepotDyes(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum VanillaDyes implements StringRepresentable
    {
        WHITE("white"),
        ORANGE("orange"),
        MAGENTA("magenta"),
        LIGHT_BLUE("light_blue"),
        YELLOW("yellow"),
        LIME("lime"),
        PINK("pink"),
        GRAY("gray"),
        LIGHT_GRAY("light_gray"),
        CYAN("cyan"),
        PURPLE("purple"),
        BLUE("blue"),
        BROWN("brown"),
        GREEN("green"),
        RED("red"),
        BLACK("black");

        final String name;

        private VanillaDyes(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

