/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.dolt_mod_how.integration.emi;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.inventory.BackpackMenu;

public class BackpackScreenHandler
implements StandardRecipeHandler<BackpackMenu> {
    public static final Component TOO_SMALL = Component.m_237115_((String)"emi.too_small");

    public List<Slot> getInputSources(BackpackMenu handler) {
        int backpackStart;
        int invStart;
        ArrayList list = Lists.newArrayList();
        for (int i = 1; i < 5; ++i) {
            list.add(handler.m_38853_(i));
        }
        for (int i = invStart = 9; i < invStart + 36; ++i) {
            list.add(handler.m_38853_(i));
        }
        for (int i = backpackStart = 46; i < backpackStart + 27; ++i) {
            list.add(handler.m_38853_(i));
        }
        return list;
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<BackpackMenu> context) {
        AbstractContainerMenu sh = context.getScreenHandler();
        if (sh instanceof RecipeBookMenu) {
            RecipeBookMenu arsh = (RecipeBookMenu)sh;
            if (recipe instanceof EmiCraftingRecipe) {
                EmiCraftingRecipe crafting = (EmiCraftingRecipe)recipe;
                return crafting.canFit(arsh.m_6635_(), arsh.m_6656_()) && super.canCraft(recipe, context);
            }
        }
        return false;
    }

    public List<Slot> getCraftingSlots(BackpackMenu handler) {
        ArrayList list = Lists.newArrayList();
        list.add(handler.m_38853_(1));
        list.add(handler.m_38853_(2));
        list.add(null);
        list.add(handler.m_38853_(3));
        list.add(handler.m_38853_(4));
        list.add(null);
        list.add(null);
        list.add(null);
        list.add(null);
        return list;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        if (recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree()) {
            if (recipe instanceof EmiCraftingRecipe) {
                EmiCraftingRecipe crafting = (EmiCraftingRecipe)recipe;
                return crafting.canFit(2, 2);
            }
            return true;
        }
        return false;
    }

    public List<Slot> getCraftingSlots(EmiRecipe recipe, BackpackMenu handler) {
        if (recipe instanceof EmiCraftingRecipe) {
            EmiCraftingRecipe craf = (EmiCraftingRecipe)recipe;
            if (craf.shapeless) {
                ArrayList list = Lists.newArrayList();
                list.add(handler.m_38853_(1));
                list.add(handler.m_38853_(2));
                list.add(handler.m_38853_(3));
                list.add(handler.m_38853_(4));
                return list;
            }
        }
        return this.getCraftingSlots(handler);
    }

    public List<ClientTooltipComponent> getTooltip(EmiRecipe recipe, EmiCraftContext<BackpackMenu> context) {
        AbstractContainerMenu sh;
        if (!this.canCraft(recipe, context) && (sh = context.getScreenHandler()) instanceof RecipeBookMenu) {
            EmiCraftingRecipe crafting;
            RecipeBookMenu arsh = (RecipeBookMenu)sh;
            if (recipe instanceof EmiCraftingRecipe && !(crafting = (EmiCraftingRecipe)recipe).canFit(arsh.m_6635_(), arsh.m_6656_())) {
                return List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)TOO_SMALL.m_7532_()));
            }
        }
        return super.getTooltip(recipe, context);
    }

    @Nullable
    public Slot getOutputSlot(BackpackMenu handler) {
        return (Slot)handler.f_38839_.get(0);
    }
}

